/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server;

import javax.jms.JMSException;
import javax.jms.ResourceAllocationException;
import javax.management.InstanceAlreadyExistsException;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.MultipleMessageHandleEvent;
import jeus.jms.common.message.admin.SingleMessageHandleEvent;
import jeus.jms.server.JMSClusterEntry;
import jeus.jms.server.JMSConsumer;
import jeus.jms.server.manager.SubscriptionManager;
import jeus.jms.server.mbean.JMSConsumerResource;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class JMSClusterConsumer
extends JMSConsumer {
    private final JMSClusterEntry entry;

    public JMSClusterConsumer(SubscriptionManager manager, JMSClusterEntry entry, int consumerID) {
        super(manager, entry.getId(), 0, consumerID);
        this.entry = entry;
        this.consumerName = entry.getName() + ".C" + consumerID;
        this.resumeDispatch();
    }

    public void handleMessage(MessageContainer packet) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6991_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6991_LEVEL, JeusMessage_JMS5._6991, packet);
        }
        AdminMessage message = (AdminMessage)packet;
        switch (message.getOperationID()) {
            case 67: {
                this.nacknowledge((MultipleMessageHandleEvent)message);
                break;
            }
            case 51: {
                this.nacknowledge((SingleMessageHandleEvent)message);
            }
        }
        super.handleMessage(message);
    }

    void closeConsumer() {
        this.shutdown();
        this.entry.consumerClosed(this.consumerID);
    }

    void handleAcknowlege(boolean transacted, MessageID messageID) {
        this.acknowledge(messageID);
    }

    void registerMBean() throws JMSException {
        try {
            this.mbean = JMSConsumerResource.createMBean(this.consumerName, (J2EEManagedObject)this.entry.getMBeanObject(), this);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new ResourceAllocationException("exception occurred creating mbean for " + this);
        }
        this.stats = this.mbean.getInitialStats();
    }

    void sendData(MessageContainer message) throws JMSException {
        message.setTargetID((byte)31);
        message.setConsumerID(this.consumerID);
        this.entry.sendAsyncRequest(this, message);
    }
}

