/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server;

import java.util.ListIterator;
import javax.jms.JMSException;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.MultipleMessageHandleEvent;
import jeus.jms.common.message.admin.SingleMessageHandleEvent;
import jeus.jms.server.AbstractConsumer;
import jeus.jms.server.manager.SubscriptionManager;

public abstract class JMSConsumer
extends AbstractConsumer {
    public JMSConsumer(SubscriptionManager manager, long entryID, int connectionID, int consumerID) {
        super(manager, entryID, connectionID, consumerID);
    }

    public void handleMessage(MessageContainer packet) throws JMSException {
        AdminMessage message = (AdminMessage)packet;
        switch (message.getOperationID()) {
            case 66: {
                this.acknowledge((MultipleMessageHandleEvent)message);
                break;
            }
            case 50: {
                this.acknowledge((SingleMessageHandleEvent)message);
                break;
            }
            default: {
                super.handleMessage(message);
            }
        }
    }

    private void acknowledge(MultipleMessageHandleEvent message) throws JMSException {
        boolean transacted = message.isTransacted();
        ListIterator it = message.getMessageIterator();
        while (it.hasNext()) {
            MessageID messageID = (MessageID)it.next();
            this.handleAcknowlege(transacted, messageID);
        }
    }

    private void acknowledge(SingleMessageHandleEvent message) throws JMSException {
        boolean transacted = message.isTransacted();
        MessageID messageID = message.getMessageID();
        this.handleAcknowlege(transacted, messageID);
    }

    abstract void handleAcknowlege(boolean var1, MessageID var2) throws JMSException;
}

