/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server;

import java.io.IOException;
import javax.jms.JMSException;
import jeus.jms.client.JMSServerEntry;
import jeus.jms.client.comm.JMSServerEntryContext;
import jeus.jms.common.JMSBaseEntry;
import jeus.jms.common.comm.FileMessageAssembler;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.FileMessageImpl;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.admin.GlobalTransactionMessage;
import jeus.jms.common.util.SerialExecutable;
import jeus.jms.server.comm.JMSBroker;
import jeus.jms.server.manager.ClusterManager;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class JMSLocalServerEntry
extends JMSServerEntry {
    private ReferenceHandler sendQueue;

    public JMSLocalServerEntry(JMSServerEntryContext entryContext) {
        super(entryContext);
        this.brokerID = ClusterManager.LOCAL_BROKER_ID;
        this.brokerName = ClusterManager.LOCAL_BROKER_NAME;
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7191_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7191_LEVEL, JeusMessage_JMS5._7191, new Object[]{new Short(this.brokerID), this.brokerName});
        }
    }

    public void start() {
        super.start();
    }

    public void setMessagePeer(JMSBaseEntry peer) {
        this.sendQueue = new ReferenceHandler(peer);
        this.setId(peer.getId());
    }

    public void sendData(MessageContainer message) throws JMSException {
        message.setEntryID(this.id);
        message.setBrokerID(this.brokerID);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7192_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7192_LEVEL, JeusMessage_JMS5._7192, new Object[]{message, this});
        }
        this.sendQueue.startExecution(message);
    }

    public void sendDirect(MessageContainer packet) throws JMSException {
        try {
            this.sendQueue.execute(packet);
        }
        catch (Exception e) {
            throw new JMSException("failed to send for " + e.toString());
        }
    }

    public void recvData(MessageContainer packet) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7193_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7193_LEVEL, JeusMessage_JMS5._7193, new Object[]{packet, this});
        }
        if (packet instanceof FileMessageImpl) {
            try {
                FileMessageAssembler assembler = new FileMessageAssembler(false);
                packet = assembler.storeFileMessage((FileMessageImpl)packet);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e.toString());
            }
        }
        super.recvData(packet);
    }

    public void prepareShutdown() {
        block3: {
            if (!this.closed.commit(false, true)) {
                return;
            }
            this.sendQueue.startExecution();
            try {
                this.sendCloseMessage();
            }
            catch (JMSException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._7194_LEVEL)) break block3;
                LogUtils.log(logger, JeusMessage_JMS5._7194_LEVEL, JeusMessage_JMS5._7194, e);
            }
        }
    }

    public boolean isRemote() {
        return false;
    }

    protected void takeover(short activeBrokerID) {
    }

    public class ReferenceHandler
    extends SerialExecutable {
        private JMSBaseEntry peer;

        public ReferenceHandler(JMSBaseEntry channel) {
            this.peer = channel;
        }

        public void execute(MessageContainer packet) {
            if (!packet.isAdminMessage()) {
                ClientMessage message = (ClientMessage)packet;
                if (!message.isTransacted()) {
                    message = (ClientMessage)message.clone();
                }
                packet = message;
            }
            if (packet.isAdminMessage() && packet instanceof GlobalTransactionMessage) {
                final MessageContainer xaPacket = packet;
                if (xaPacket.isXAExecutable()) {
                    JMSBroker.getLocalBroker().getCachedSerialExecutor().executeForced(new Runnable(){

                        public void run() {
                            ReferenceHandler.this.peer.recvData(xaPacket);
                        }
                    });
                } else {
                    JMSBroker.getLocalBroker().getSerialExecutor().executeForced(new Runnable(){

                        public void run() {
                            ReferenceHandler.this.peer.recvData(xaPacket);
                        }
                    });
                }
            } else {
                this.peer.recvData(packet);
            }
        }

        public boolean postExecution(MessageContainer packet) {
            packet.messageEvent((byte)4);
            return super.postExecution(packet);
        }
    }
}

