/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server;

import javax.jms.JMSException;
import javax.jms.ResourceAllocationException;
import javax.management.InstanceAlreadyExistsException;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.server.JMSConsumer;
import jeus.jms.server.JMSSession;
import jeus.jms.server.manager.SubscriptionManager;
import jeus.jms.server.mbean.JMSConsumerResource;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class JMSMessageConsumer
extends JMSConsumer {
    private final JMSSession session;

    public JMSMessageConsumer(SubscriptionManager manager, JMSSession session, long entryID, int connectionID, int consumerID) {
        super(manager, entryID, connectionID, consumerID);
        this.session = session;
        this.consumerName = session + ".C" + consumerID;
    }

    public JMSSession getSession() {
        return this.session;
    }

    public void handleException(MessageContainer packet, JMSException e) {
        super.handleException(packet, e);
        this.checkTransacted((AdminMessage)packet);
    }

    private void checkTransacted(AdminMessage message) {
        switch (message.getOperationID()) {
            case 50: 
            case 66: {
                boolean isTransacted = message.getBooleanFlag();
                if (!isTransacted) break;
                this.session.failedTransaction();
            }
        }
    }

    void handleAcknowlege(boolean transacted, MessageID messageID) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5941_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5941_LEVEL, JeusMessage_JMS5._5941, new Object[]{transacted ? "transacted " : "", messageID});
        }
        if (transacted) {
            this.session.enlistConsumer(messageID, this.manager);
        } else {
            this.acknowledge(messageID);
        }
    }

    public void closeConsumer() {
        this.shutdown();
        this.session.removeConsumer(this.consumerID);
    }

    void registerMBean() throws JMSException {
        try {
            this.mbean = JMSConsumerResource.createMBean(this.consumerName, (J2EEManagedObject)this.session.getMBeanObject(), this);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new ResourceAllocationException("exception occurred creating mbean for " + this);
        }
        this.stats = this.mbean.getInitialStats();
        this.session.addJMSConsumerStats(this.stats);
    }

    void destroyMBean() {
        super.destroyMBean();
        this.session.removeJMSConsumerStats(this.stats);
    }

    void sendData(MessageContainer message) throws JMSException {
        message.setTargetID((byte)31);
        message.setConsumerID(this.consumerID);
        this.session.sendMessage(message);
    }
}

