/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server;

import javax.jms.JMSException;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import jeus.jms.common.JMSEnvironmentValues;
import jeus.jms.common.JMSProperties;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.server.comm.JMSBroker;
import jeus.jms.server.config.JMSConfig;
import jeus.jms.server.external.TransactionServerProvider;
import jeus.jms.server.mbean.JMSEngineMo;
import jeus.jms.server.mbean.JMSResource;
import jeus.security.util.LoginUtil;
import jeus.util.EnvironmentCall;
import jeus.util.Runner;
import jeus.util.concurrent.Sync;
import jeus.util.concurrent.SynchronizedBoolean;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS;
import jeus.util.message.JeusMessage_JMS5;
import jeus.util.properties.JeusJMXPropertyValues;
import jeus.util.properties.JeusManagerPropertyValues;

public final class JMSServer {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    public static final String EMBEDDED_SAF_ENGINE_NAME = "JEUS_MQ_SAF_ENGINE";
    private static final String EMBEDDED_ENGINE_NAME = "embedded";
    private static boolean STANDALONE;
    private static boolean SAF_ENGINE;
    private String engineName;
    private SynchronizedBoolean shutdown;
    private JMSResource resource;
    private JMSEngineMo engine;
    private JMSConfig descriptor;
    private static JMSServer server;
    private static long serverStartTime;

    public static boolean isStandalone() {
        return STANDALONE;
    }

    public static boolean isSAFEngine() {
        return SAF_ENGINE;
    }

    private JMSServer(String engineName, JMSConfig descriptor) throws JMSException {
        this.engineName = engineName;
        this.descriptor = descriptor;
        JMSProperties.CLIENT_MODE = false;
    }

    private ObjectName parentName() {
        return JMSServer.isStandalone() ? null : JeusManagerPropertyValues.serverMBeanObjectName;
    }

    public JMSConfig getDescriptor() {
        return this.descriptor;
    }

    public static JMSServer createSafEngine() throws JMSException {
        serverStartTime = System.currentTimeMillis();
        STANDALONE = true;
        SAF_ENGINE = true;
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6823_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6823_LEVEL, JeusMessage_JMS5._6823, EMBEDDED_SAF_ENGINE_NAME);
        }
        EnvironmentCall.resetEnvironmentCall();
        JeusJMXPropertyValues.mBeanServer = MBeanServerFactory.createMBeanServer();
        JeusJMXPropertyValues.jmxMgrName = EMBEDDED_SAF_ENGINE_NAME;
        String configPath = JMSEnvironmentValues.getClientWorkDir();
        JMSConfig jmsConfig = new JMSConfig(EMBEDDED_SAF_ENGINE_NAME, configPath);
        server = new JMSServer(EMBEDDED_SAF_ENGINE_NAME, jmsConfig);
        server.start();
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6821_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6821_LEVEL, JeusMessage_JMS5._6821, EMBEDDED_SAF_ENGINE_NAME);
        }
        return server;
    }

    public static JMSServer getJMSServer() {
        return server;
    }

    public static void main(String[] args) throws JMSException {
        String engineName = args[0];
        serverStartTime = System.currentTimeMillis();
        String configPath = args.length > 1 ? args[1] : null;
        JMSConfig jmsConfig = new JMSConfig(engineName, configPath);
        if (engineName.equals(EMBEDDED_ENGINE_NAME)) {
            STANDALONE = true;
        } else if (engineName.equals(EMBEDDED_SAF_ENGINE_NAME)) {
            STANDALONE = true;
            SAF_ENGINE = true;
        } else {
            if (!Runner.checkLicenseEdition((int)Runner.LIC_EDITION_STANDARD)) {
                throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._4006);
            }
            if (jmsConfig.getCluster() != null && !Runner.checkLicenseEdition((int)Runner.LIC_EDITION_ENTERPRISE)) {
                throw JMSExceptionFactory.createJMSException(JeusMessage_JMS._4917);
            }
        }
        if (STANDALONE) {
            EnvironmentCall.resetEnvironmentCall();
            JeusJMXPropertyValues.mBeanServer = MBeanServerFactory.createMBeanServer();
            JeusJMXPropertyValues.jmxMgrName = engineName;
        }
        server = new JMSServer(engineName, jmsConfig);
        server.start();
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6822_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6822_LEVEL, JeusMessage_JMS5._6822);
        }
    }

    public static void shutdownStatic() {
        server.shutdown();
    }

    public synchronized void start() throws JMSException {
        Sync lock = JMSBroker.getLocalBroker().getLock().writeLock();
        try {
            lock.acquire();
        }
        catch (InterruptedException e) {
            throw JMSExceptionFactory.createJMSException(e.getMessage(), (Exception)e);
        }
        this.shutdown = new SynchronizedBoolean(false, (Object)this);
        try {
            LoginUtil.loginCodeSubjectWithRuntimeException();
            TransactionServerProvider provider = TransactionServerProvider.getTransactionServerProvider();
            if (provider != null) {
                provider.waitForRecovery();
            }
            this.resource = new JMSResource(this.engineName, this.descriptor, this.parentName());
            this.engine = JMSEngineMo.createMBean(this.engineName, this.parentName(), this);
            this.resource.start();
        }
        catch (Exception ex) {
            this.shutdown();
            throw JMSExceptionFactory.createJMSException("failed to start JMS server", ex);
        }
        finally {
            lock.release();
            LoginUtil.logoutWithRuntimeException();
        }
    }

    public synchronized void shutdown() {
        if (!this.shutdown.commit(false, true)) {
            return;
        }
        if (this.resource != null) {
            this.resource.shutdown();
        }
        if (this.engine != null) {
            this.engine.destroyMBean();
        }
    }

    public JMSResource getJMSResource() {
        return this.resource;
    }

    public static long getServerStartTime() {
        return serverStartTime;
    }
}

