/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server;

import java.util.ListIterator;
import javax.jms.JMSException;
import jeus.jms.common.message.MessageContainer;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.jms.common.message.admin.MultipleMessageHandleEvent;
import jeus.jms.common.message.admin.SingleMessageHandleEvent;
import jeus.jms.server.manager.SubscriptionGroupManager;
import jeus.jms.server.manager.SubscriptionManager;
import jeus.jms.server.message.ServerMessage;
import jeus.util.concurrent.SynchronizedBoolean;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public abstract class MessageDispatcher {
    protected final SubscriptionManager manager;
    protected final SynchronizedBoolean closed;
    protected final SynchronizedBoolean async;
    private SubscriptionGroupManager listener;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    public MessageDispatcher(SubscriptionManager manager) {
        this.manager = manager;
        this.closed = new SynchronizedBoolean(false);
        this.async = new SynchronizedBoolean(false);
    }

    protected void syncRequest(AdminMessage request) {
        this.manager.syncRequest(request);
    }

    protected void asyncRequest(AdminMessage request) {
        this.async.set(request.getBooleanFlag());
        if (this.listener != null) {
            this.listener.addAsyncConsumer();
        }
        if (this.manager.isCluster()) {
            this.manager.setWeight(request.getIntegerFlag());
        }
        if (this.async.get()) {
            this.manager.asyncRequest();
        }
    }

    protected void startConsumer() {
        this.resumeDispatch();
        this.executeDispatch();
    }

    protected void stopConsumer() {
        this.suspendDispatch();
        this.manager.cancelSyncRequests();
    }

    protected void prepareShutdown() {
        this.stopConsumer();
        if (!this.closed.commit(false, true)) {
            return;
        }
        if (this.listener != null) {
            this.listener.removeAsyncConsumer();
        }
        this.manager.consumerClosed();
    }

    protected void executeDispatch() {
        if (this.isAsyncDispatchable()) {
            this.manager.executeDispatch();
        }
    }

    protected void resumeDispatch() {
        this.manager.setSuspend(false);
    }

    protected void suspendDispatch() {
        this.manager.setSuspend(true);
    }

    protected void sendReply(MessageContainer message) throws JMSException {
        message.setRequestFlag(false);
        this.sendData(message);
    }

    abstract void sendData(MessageContainer var1) throws JMSException;

    public boolean dispatch(ServerMessage message) throws JMSException {
        if (this.closed.get()) {
            return false;
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6851_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6851_LEVEL, JeusMessage_JMS5._6851, new Object[]{message, this});
        }
        this.sendData(message);
        return true;
    }

    public boolean isAsyncDispatchable() {
        return !this.closed.get() && this.async.get();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public SubscriptionManager getSubscriptionManager() {
        return this.manager;
    }

    protected void poisonedMessage(SingleMessageHandleEvent event) {
        this.manager.poisonedMessage(event.getMessageID());
    }

    protected void poisonedMessage(MultipleMessageHandleEvent event) {
        ListIterator it = event.getInverseMessageIterator();
        while (it.hasPrevious()) {
            MessageID messageID = (MessageID)it.previous();
            this.manager.poisonedMessage(messageID);
        }
    }

    protected void returnBack(MultipleMessageHandleEvent message) {
        ListIterator it = message.getInverseMessageIterator();
        while (it.hasPrevious()) {
            MessageID messageID = (MessageID)it.previous();
            this.manager.returnBack(messageID);
        }
    }

    protected void returnBack(SingleMessageHandleEvent message) {
        MessageID messageID = message.getMessageID();
        this.manager.returnBack(messageID);
    }

    protected void acknowledge(MessageID messageID) {
        this.manager.acknowledge(messageID);
    }

    protected void recover(MessageID messageID) {
        this.manager.recover(messageID);
    }

    protected void nacknowledge(SingleMessageHandleEvent event) {
        this.manager.nacknowledge(event.getMessageID());
    }

    protected void nacknowledge(MultipleMessageHandleEvent event) {
        ListIterator it = event.getMessageIterator();
        while (it.hasNext()) {
            MessageID messageID = (MessageID)it.next();
            this.manager.nacknowledge(messageID);
        }
    }

    public void setListener(SubscriptionGroupManager listener) {
        this.listener = listener;
    }
}

