/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.comm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import jeus.jms.common.JMSBaseEntry;
import jeus.jms.common.JMSServiceChannelAddress;
import jeus.jms.common.message.admin.TakeoverMessage;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.JMSRequestManager;
import jeus.jms.common.util.SerialExecutor;
import jeus.jms.server.JMSClientEntry;
import jeus.jms.server.JMSClusterEntry;
import jeus.jms.server.JMSRemoteClientEntry;
import jeus.jms.server.comm.JMSEntryRegistry;
import jeus.jms.server.comm.JMSEntryRegistryImpl;
import jeus.jms.server.comm.JMSServiceChannel;
import jeus.jms.server.manager.ClusterManager;
import jeus.jms.server.manager.ThreadPoolManager;
import jeus.jms.server.mbean.JMSResource;
import jeus.util.ErrorMsgManager;
import jeus.util.LinkedHashMap;
import jeus.util.concurrent.ReadWriteLock;
import jeus.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import jeus.util.concurrent.SynchronizedInt;
import jeus.util.concurrent50.concurrent.Executor;
import jeus.util.message.JeusMessage_JMS;
import jeus.xml.binding.jeusDD.ServiceConfig;

public class JMSBroker
implements JMSEntryRegistry {
    private static JMSBroker instance;
    private JMSEntryRegistryImpl registry;
    private JMSRequestManager manager;
    private List channelDescriptors;
    private LinkedHashMap channels;
    private List channelAddrs;
    private JMSResource engine;
    private SynchronizedInt clients;
    private ReentrantWriterPreferenceReadWriteLock lock = new ReentrantWriterPreferenceReadWriteLock();

    public static synchronized JMSBroker getLocalBroker() {
        if (instance == null) {
            instance = new JMSBroker();
        }
        return instance;
    }

    public short getBrokerID() {
        return ClusterManager.LOCAL_BROKER_ID;
    }

    public String getBrokerName() {
        return ClusterManager.LOCAL_BROKER_NAME;
    }

    public JMSRequestManager getRequestManager() {
        return this.manager;
    }

    public SerialExecutor getSerialExecutor() {
        return new SerialExecutor((Executor)ThreadPoolManager.getThreadPool());
    }

    public SerialExecutor getCachedSerialExecutor() {
        return new SerialExecutor((Executor)ThreadPoolManager.getCachedThreadPool());
    }

    public void initialize(JMSResource engine, List channelDescriptors) throws JMSException, IOException {
        this.engine = engine;
        this.channelDescriptors = channelDescriptors;
        this.initialize();
    }

    private void initialize() throws JMSException, IOException {
        this.manager = new JMSRequestManager();
        this.registry = new JMSEntryRegistryImpl();
        this.channels = new LinkedHashMap();
        this.channelAddrs = new ArrayList();
        this.clients = new SynchronizedInt(0);
        for (ServiceConfig config : this.channelDescriptors) {
            try {
                this.initServiceChannel((ServiceConfig)config.cloneType());
            }
            catch (Exception e) {
                throw JMSExceptionFactory.createJMSException(e.getMessage(), e);
            }
        }
    }

    private void initServiceChannel(ServiceConfig config) throws JMSException {
        try {
            JMSServiceChannel channel = this.createServiceChannel(config);
            this.channels.put((Object)config.getName(), (Object)channel);
            this.channelAddrs.add(channel.getServiceChannelAddress());
        }
        catch (Exception ex) {
            throw JMSExceptionFactory.createJMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4009, (Object)config.getServerUrl()), ex);
        }
    }

    private JMSServiceChannel createServiceChannel(ServiceConfig config) throws Exception {
        JMSServiceChannel channel = new JMSServiceChannel(this.engine, config);
        channel.init();
        return channel;
    }

    public void start() throws IOException {
        for (JMSServiceChannel channel : this.channels.values()) {
            channel.start();
        }
    }

    public boolean registerClientEntry(JMSClientEntry entry) {
        if (this.registry.registerClientEntry(entry)) {
            this.clients.increment();
            return true;
        }
        return false;
    }

    public boolean unregisterClientEntry(JMSClientEntry client) {
        if (this.registry.unregisterClientEntry(client)) {
            this.clients.decrement();
            return true;
        }
        return false;
    }

    public boolean registerRemoteClientEntry(JMSRemoteClientEntry client) {
        if (this.registry.registerRemoteClientEntry(client)) {
            this.clients.increment();
            return true;
        }
        return false;
    }

    public boolean unregisterRemoteClientEntry(JMSRemoteClientEntry client) {
        if (this.registry.unregisterRemoteClientEntry(client)) {
            this.clients.decrement();
            return true;
        }
        return false;
    }

    public boolean registerClusterEntry(short brokerID, JMSClusterEntry client) {
        return this.registry.registerClusterEntry(brokerID, client);
    }

    public boolean unregisterClusterEntry(short brokerID, JMSClusterEntry client) {
        return this.registry.unregisterClusterEntry(brokerID, client);
    }

    public JMSClusterEntry findClusterEntry(short brokerID) {
        return this.registry.findClusterEntry(brokerID);
    }

    public JMSClusterEntry getClusterEntry(short brokerID) throws InvalidDestinationException {
        return this.registry.getClusterEntry(brokerID);
    }

    public JMSClientEntry findClientEntry(long entryID) {
        return this.registry.findClientEntry(entryID);
    }

    public JMSClientEntry getClientEntry(long entryID) throws InvalidDestinationException {
        return this.registry.getClientEntry(entryID);
    }

    public JMSRemoteClientEntry findRemoteClientEntry(long entryID) {
        return this.registry.findRemoteClientEntry(entryID);
    }

    public void shutdown() {
        if (this.channels == null) {
            return;
        }
        Collection collection = this.channels.values();
        JMSServiceChannel[] servers = collection.toArray(new JMSServiceChannel[collection.size()]);
        for (int i = 0; i < servers.length; ++i) {
            JMSServiceChannel server = servers[i];
            server.shutdown();
        }
        this.registry.shutdown();
        this.channelDescriptors.clear();
        this.channels.clear();
        this.engine = null;
    }

    public JMSServiceChannel getServiceChannel(String serviceName) throws JMSException {
        JMSServiceChannel channel = (JMSServiceChannel)this.channels.get((Object)serviceName);
        if (channel == null) {
            throw new JMSException("invalid service name [" + serviceName + "]");
        }
        return channel;
    }

    public JMSServiceChannel getFirstChannel() {
        return (JMSServiceChannel)this.channels.getValue(0);
    }

    public boolean isLocalBrokerAddress(JMSServiceChannelAddress addr) {
        if (this.channelAddrs == null) {
            return false;
        }
        return this.channelAddrs.contains(addr);
    }

    public Map getServiceChannels() {
        return this.channels;
    }

    public ReadWriteLock getLock() {
        return this.lock;
    }

    public void shutdownClients() {
        this.registry.shutdownClients();
    }

    public void prepareTakeover(short activeBrokerID) {
        TakeoverMessage msg = new TakeoverMessage(activeBrokerID);
        JMSBaseEntry[] clients = this.registry.getClientList().toArray(new JMSBaseEntry[0]);
        for (int i = 0; i < clients.length; ++i) {
            JMSBaseEntry client = clients[i];
            try {
                client.sendNotifyMessage(msg);
                continue;
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }
}

