/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.ResourceAllocationException;
import javax.management.InstanceAlreadyExistsException;
import jeus.jms.client.facility.factory.JeusXAConnectionFactory;
import jeus.jms.common.JMSServiceChannelAddress;
import jeus.jms.server.comm.JMSBroker;
import jeus.jms.server.comm.JMSServiceChannel;
import jeus.jms.server.config.FactoryConstants;
import jeus.jms.server.manager.ConnectionManager;
import jeus.jms.server.mbean.JMSConnectionFactoryResource;
import jeus.jms.server.mbean.JMSQueueConnectionFactoryResource;
import jeus.jms.server.mbean.JMSResource;
import jeus.jms.server.mbean.JMSTopicConnectionFactoryResource;
import jeus.jms.server.util.JaxbUtil;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS;
import jeus.util.message.JeusMessage_JMS5;
import jeus.xml.binding.jeusDD.ConnectionFactoryType;
import jeus.xml.binding.jeusDD.FactoryTypeType;
import jeus.xml.binding.jeusDD.JmsThreadPoolType;
import jeus.xml.binding.jeusDD.ObjectFactory;

public class ConnectionFactoryUtil
extends FactoryConstants {
    private static HashMap map;
    private static JMSResource parent;
    protected static final JeusLogger logger;

    public static void init(JMSResource resource) {
        parent = resource;
        map = new HashMap();
    }

    public static ConnectionFactoryType createFactoryType(String type, String factoryName, String exportName, String clientID, int maxThread) throws JMSException {
        ObjectFactory factory = new ObjectFactory();
        ConnectionFactoryType ftype = factory.createConnectionFactoryType();
        ftype.setType(FactoryTypeType.fromValue((String)type));
        ftype.setName(factoryName);
        if (exportName == null) {
            exportName = factoryName;
        }
        ftype.setExportName(exportName);
        if ("topic".equals(type) || "xatopic".equals(type)) {
            ftype.setClientId(clientID);
            ftype.setFixedClientId(Boolean.valueOf(clientID != null && !clientID.equals("")));
        }
        if (maxThread != 0) {
            JmsThreadPoolType threadPool = factory.createJmsThreadPoolType();
            threadPool.setMax(new Integer(maxThread));
            ftype.setThreadPool(threadPool);
        }
        return ftype;
    }

    public static JMSConnectionFactoryResource createFactory(ConnectionFactoryType factory) throws JMSException {
        String name = factory.getName();
        if (name == null) {
            throw new ResourceAllocationException("factory name must be set");
        }
        String factoryType = JaxbUtil.getWithDefault(factory.getType(), factory.getDefaultType()).value();
        int type = ConnectionFactoryUtil.getType(factoryType);
        String clientID = factory.getClientId();
        boolean fixed = JaxbUtil.getWithDefault(factory.isFixedClientId(), factory.getDefaultFixedClientId());
        String exportName = factory.getExportName();
        if (exportName == null) {
            exportName = name;
        }
        boolean cluster = JaxbUtil.getWithDefault(factory.isClusteredFactory(), factory.getDefaultClusteredFactory());
        JmsThreadPoolType thPoolType = factory.getThreadPool();
        int maxThread = thPoolType == null ? -1 : JaxbUtil.getWithDefault(thPoolType.getMax(), thPoolType.getDefaultMax());
        String policyType = JaxbUtil.getWithDefault(factory.getBrokerSelectionPolicy(), factory.getDefaultBrokerSelectionPolicy()).value();
        JMSServiceChannel channel = ConnectionFactoryUtil.getServiceChannel(factory);
        HashSet<JMSServiceChannelAddress> addresses = new HashSet<JMSServiceChannelAddress>();
        JMSServiceChannelAddress serviceChannelAddress = channel.getServiceChannelAddress();
        addresses.add(serviceChannelAddress);
        return ConnectionFactoryUtil.createFactory(addresses, policyType, type, channel.isSupportSSL(), name, exportName, cluster, maxThread, clientID, fixed);
    }

    private static JMSServiceChannel getServiceChannel(ConnectionFactoryType factory) throws JMSException {
        JMSBroker broker = JMSBroker.getLocalBroker();
        return factory.isSetService() ? broker.getServiceChannel(factory.getService()) : broker.getFirstChannel();
    }

    public static String getTypeString(int type) {
        switch (type) {
            case 0: {
                return "nonxa";
            }
            case 1: {
                return "queue";
            }
            case 2: {
                return "topic";
            }
            case 3: {
                return "xa";
            }
            case 4: {
                return "xaqueue";
            }
            case 5: {
                return "xatopic";
            }
        }
        return "invalid type connection factory " + type;
    }

    private static JMSConnectionFactoryResource createFactory(HashSet addresses, String policyType, int type, boolean supportSSL, String name, String exportName, boolean cluster, int maxThread, String clientID, boolean fixed) throws JMSException {
        JMSConnectionFactoryResource resource = ConnectionFactoryUtil.createFactoryMBean(addresses, policyType, supportSSL, type, name, exportName, cluster, maxThread, clientID, fixed);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5051_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5051_LEVEL, JeusMessage_JMS5._5051, resource);
        }
        map.put(name, resource);
        return resource;
    }

    private static JMSConnectionFactoryResource createFactoryMBean(HashSet addresses, String policyType, boolean supportSSL, int type, String name, String exportName, boolean cluster, int maxThread, String clientID, boolean fixed) throws JMSException {
        ConnectionFactoryUtil.checkExistence(name);
        ConnectionFactoryUtil.checkClientID(clientID);
        try {
            switch (type) {
                case 0: {
                    JeusXAConnectionFactory cf = new JeusXAConnectionFactory(name, type, addresses, policyType, maxThread, clientID, fixed, supportSSL, cluster);
                    return JMSConnectionFactoryResource.createMBean(name, parent, cf, exportName);
                }
                case 2: {
                    JeusXAConnectionFactory tcf = new JeusXAConnectionFactory(name, type, addresses, policyType, maxThread, clientID, fixed, supportSSL, cluster);
                    return JMSTopicConnectionFactoryResource.createMBean(name, parent, tcf, exportName);
                }
                case 1: {
                    JeusXAConnectionFactory qcf = new JeusXAConnectionFactory(name, type, addresses, policyType, maxThread, clientID, fixed, supportSSL, cluster);
                    return JMSQueueConnectionFactoryResource.createMBean(name, parent, qcf, exportName);
                }
                case 3: {
                    JeusXAConnectionFactory xcf = new JeusXAConnectionFactory(name, type, addresses, policyType, maxThread, clientID, fixed, supportSSL, cluster);
                    return JMSConnectionFactoryResource.createMBean(name, parent, xcf, exportName);
                }
                case 5: {
                    JeusXAConnectionFactory xtcf = new JeusXAConnectionFactory(name, type, addresses, policyType, maxThread, clientID, fixed, supportSSL, cluster);
                    return JMSTopicConnectionFactoryResource.createMBean(name, parent, xtcf, exportName);
                }
                case 4: {
                    JeusXAConnectionFactory xqcf = new JeusXAConnectionFactory(name, type, addresses, policyType, maxThread, clientID, fixed, supportSSL, cluster);
                    return JMSQueueConnectionFactoryResource.createMBean(name, parent, xqcf, exportName);
                }
            }
            throw new JMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._3120, (Object)String.valueOf(type)));
        }
        catch (InstanceAlreadyExistsException e) {
            ConnectionFactoryUtil.unregisterClientID(clientID);
            throw new JMSException("failed to register mbean for connection factory " + name);
        }
    }

    public static void checkExistence(String name) throws JMSException {
        if (map.containsKey(name)) {
            throw new JMSException("connection factory '" + name + "' already exists");
        }
    }

    private static void checkClientID(String clientID) throws ResourceAllocationException {
        if (clientID == null || clientID.equals("")) {
            return;
        }
        if (ConnectionManager.isClientIDActive(clientID)) {
            throw new ResourceAllocationException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4074, (Object[])new Object[]{clientID, "(dynamic binding)"}));
        }
    }

    private static boolean unregisterClientID(String clientID) {
        if (clientID == null || clientID.equals("")) {
            return false;
        }
        return ConnectionManager.unregisterClientID(clientID);
    }

    public static void destroyConnectionFactory(String name) throws JMSException {
        JMSConnectionFactoryResource resource = ConnectionFactoryUtil.removeConnectionFactoryResource(name);
        if (resource == null) {
            throw new InvalidDestinationException("unable to find connection factory " + name);
        }
        resource.stop();
        resource.destroyMBean();
    }

    public static JMSConnectionFactoryResource getConnectionFactoryResource(String name) throws InvalidDestinationException {
        JMSConnectionFactoryResource resource = (JMSConnectionFactoryResource)map.get(name);
        if (resource == null) {
            throw new InvalidDestinationException("cannot find connection factory " + name);
        }
        return resource;
    }

    private static JMSConnectionFactoryResource removeConnectionFactoryResource(String name) {
        return (JMSConnectionFactoryResource)map.remove(name);
    }

    public static synchronized void start() {
        JMSConnectionFactoryResource[] mbeans = map.values().toArray(new JMSConnectionFactoryResource[0]);
        for (int i = 0; i < mbeans.length; ++i) {
            JMSConnectionFactoryResource mbean = mbeans[i];
            try {
                mbean.start();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static synchronized void shutdown() {
        if (map == null) {
            return;
        }
        Collection collection = map.values();
        JMSConnectionFactoryResource[] mbeans = collection.toArray(new JMSConnectionFactoryResource[collection.size()]);
        for (int i = 0; i < mbeans.length; ++i) {
            JMSConnectionFactoryResource mbean = mbeans[i];
            mbean.stop();
            mbean.destroyMBean();
        }
        map.clear();
    }

    public static synchronized List getDigest() {
        ArrayList<String> result = new ArrayList<String>();
        for (JMSConnectionFactoryResource mbean : map.values()) {
            result.add(mbean.toString());
        }
        return result;
    }

    static {
        logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    }
}

