/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.config;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jeus.jms.common.util.ProtocolUtil;
import jeus.jms.server.config.DurableSubscriptionIdentity;
import jeus.xml.binding.jeusDD.DurableSubscriberType;

public class DurableSubscriptionConfig
extends DurableSubscriptionIdentity {
    private boolean admin;
    private boolean nolocal;
    private String selector;
    private String destName;
    private boolean cluster;

    public DurableSubscriptionConfig(String destName, String clientID, String durableName, String selector, boolean nolocal, boolean cluster) {
        super(clientID, durableName);
        this.nolocal = nolocal;
        this.destName = destName;
        this.selector = selector;
    }

    public DurableSubscriptionConfig(String destName, String clientID, String durableName, String selector) {
        super(clientID, durableName);
        this.destName = destName;
        this.selector = selector;
        this.cluster = true;
    }

    public DurableSubscriptionConfig(long id, DataInput in) throws IOException {
        this.id = id;
        this.readExternal(in);
    }

    public DurableSubscriptionConfig(DurableSubscriberType type) {
        super(type.getClientId(), type.getName());
        this.destName = type.getDestinationName();
        this.selector = type.getMessageSelector();
        this.admin = true;
    }

    public String getDestinationName() {
        return this.destName;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getDurableName() {
        return this.durableName;
    }

    public String getSelector() {
        return this.selector;
    }

    public boolean isNolocal() {
        return this.nolocal;
    }

    public void setNolocal(boolean nolocal) {
        this.nolocal = nolocal;
    }

    public boolean isCluster() {
        return this.cluster;
    }

    public void setCluster(boolean cluster) {
        this.cluster = cluster;
    }

    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        this.admin = in.readBoolean();
        this.nolocal = in.readBoolean();
        this.destName = ProtocolUtil.readString(in);
        this.selector = ProtocolUtil.readString(in);
        this.cluster = in.readBoolean();
    }

    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.admin);
        out.writeBoolean(this.nolocal);
        ProtocolUtil.writeString(this.destName, out);
        ProtocolUtil.writeString(this.selector, out);
        out.writeBoolean(this.cluster);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("DTSI {");
        b.append(this.id).append(':');
        b.append(this.clientID).append(':');
        b.append(this.durableName).append(':');
        b.append(this.selector == null ? "" : this.selector).append("::");
        b.append(this.destName);
        b.append("}");
        return b.toString();
    }
}

