/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import jeus.jms.server.comm.JMSBroker;
import jeus.jms.server.manager.DispatchMessageQueue;
import jeus.util.LinkedHashMap;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class AcknowledgeQueue
extends LinkedHashMap {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    private DispatchMessageQueue queue;
    private int maxPendingLimit;
    private float resumeDispatchFactor;

    public AcknowledgeQueue(DispatchMessageQueue queue, int maxPendingLimit, float resumeDispatchFactor) {
        this.queue = queue;
        this.maxPendingLimit = maxPendingLimit;
        this.resumeDispatchFactor = resumeDispatchFactor;
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6481_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6481_LEVEL, JeusMessage_JMS5._6481, new Object[]{new Integer(this.maxPendingLimit), new Float(this.resumeDispatchFactor)});
        }
    }

    private void checkSuspend() {
        if (!this.queue.syncRequested() && !this.queue.isSuspended() && this.maxPendingLimit <= this.size()) {
            this.queue.setSuspend(true);
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6482_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6482_LEVEL, JeusMessage_JMS5._6482, new Object[]{new Integer(this.size()), new Integer(this.queue.getQueueSize())});
            }
        }
    }

    private void checkResume() {
        if (!this.queue.syncRequested() && this.queue.isSuspended() && (float)this.maxPendingLimit * this.resumeDispatchFactor >= (float)this.size()) {
            this.queue.setSuspend(false);
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6483_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6483_LEVEL, JeusMessage_JMS5._6483, new Object[]{new Integer(this.size()), new Integer(this.queue.getQueueSize())});
            }
            if (this.queue.getQueueSize() > 0) {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6484_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._6484_LEVEL, JeusMessage_JMS5._6484);
                }
                JMSBroker.getLocalBroker().getSerialExecutor().execute(this.queue);
            }
        }
    }

    public Object put(Object key, Object value) {
        Object o = super.put(key, value);
        this.checkSuspend();
        return o;
    }

    public Object remove(Object key) {
        Object o = super.remove(key);
        this.checkResume();
        return o;
    }

    public Object recover(Object key, Object value) {
        Object o = super.recover(key, value);
        this.checkSuspend();
        return o;
    }

    public void recover(LinkedHashMap t) {
        super.recover(t);
        this.checkSuspend();
    }
}

