/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import java.util.Map;
import javax.jms.JMSException;
import jeus.jms.common.JMSEntry;
import jeus.jms.common.message.MessageUtil;
import jeus.jms.common.message.admin.AdminMessage;
import jeus.util.LinkedHashMap;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class ClusterCallbackManager {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    private int current;
    private Map producers = new LinkedHashMap();

    public synchronized void registerCallback(int consumerID, JMSEntry entry) {
        this.producers.put(new Integer(consumerID), new PeerCallback(consumerID, entry));
    }

    public synchronized void unregisterCallback(int consumerID) {
        this.producers.remove(new Integer(consumerID));
    }

    public synchronized void start() {
        PeerCallback[] callbacks = this.producers.values().toArray(new PeerCallback[0]);
        for (int i = 0; i < callbacks.length; ++i) {
            PeerCallback callback = callbacks[i];
            try {
                callback.start();
                continue;
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void changeRequest(int count) {
        PeerCallback[] callbacks = this.producers.values().toArray(new PeerCallback[0]);
        for (int i = 0; i < callbacks.length; ++i) {
            PeerCallback callback = callbacks[i];
            try {
                callback.changeRequest(count);
                continue;
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
        this.current = count;
    }

    public synchronized void suspend() {
        PeerCallback[] callbacks = this.producers.values().toArray(new PeerCallback[0]);
        for (int i = 0; i < callbacks.length; ++i) {
            PeerCallback callback = callbacks[i];
            try {
                callback.suspend();
                continue;
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void resume() {
        PeerCallback[] callbacks = this.producers.values().toArray(new PeerCallback[0]);
        for (int i = 0; i < callbacks.length; ++i) {
            PeerCallback callback = callbacks[i];
            try {
                callback.resume();
                continue;
            }
            catch (JMSException e) {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6671_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._6671_LEVEL, JeusMessage_JMS5._6671, new Integer(callback.consumerID), (Throwable)e);
                }
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6672_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._6672_LEVEL, JeusMessage_JMS5._6672, new Integer(callback.consumerID));
                }
                this.producers.remove(new Integer(callback.consumerID));
            }
        }
    }

    public int getCurrent() {
        return this.current;
    }

    private class PeerCallback {
        private int consumerID;
        private JMSEntry entry;

        private PeerCallback(int consumerID, JMSEntry entry) {
            this.consumerID = consumerID;
            this.entry = entry;
        }

        private void changeRequest(int count) throws JMSException {
            AdminMessage request = MessageUtil.createAdminMessage((byte)33);
            request.setIntegerFlag(count);
            request.setBooleanFlag(true);
            this.sendMessage(request);
        }

        public void start() throws JMSException {
            AdminMessage request = MessageUtil.createAdminMessage((byte)33);
            request.setBooleanFlag(true);
            this.sendMessage(request);
        }

        private void suspend() throws JMSException {
            AdminMessage request = MessageUtil.createAdminMessage((byte)34);
            this.sendMessage(request);
        }

        private void resume() throws JMSException {
            AdminMessage request = MessageUtil.createAdminMessage((byte)35);
            this.sendMessage(request);
        }

        private void sendMessage(AdminMessage request) throws JMSException {
            request.setTargetID((byte)31);
            request.setConsumerID(this.consumerID);
            this.entry.sendRequestMessage(request);
        }
    }
}

