/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.ResourceAllocationException;
import javax.jms.TransactionInProgressException;
import javax.management.ObjectName;
import jeus.jms.common.JMSBaseEntry;
import jeus.jms.common.destination.JeusDestination;
import jeus.jms.common.message.MessageEvent;
import jeus.jms.common.util.SerialExecutor;
import jeus.jms.server.comm.ClusteredPeer;
import jeus.jms.server.manager.AdministeredObjectBinder;
import jeus.jms.server.manager.ClusterCallbackManager;
import jeus.jms.server.manager.ClusterManager;
import jeus.jms.server.manager.DestinationMessageManager;
import jeus.jms.server.manager.DestinationUtil;
import jeus.jms.server.manager.Scheduler;
import jeus.jms.server.manager.StorageManager;
import jeus.jms.server.manager.SubscriptionContext;
import jeus.jms.server.manager.SubscriptionManager;
import jeus.jms.server.manager.Takeoverable;
import jeus.jms.server.manager.ThreadPoolManager;
import jeus.jms.server.manager.TransactedDestination;
import jeus.jms.server.mbean.JMSDestinationResource;
import jeus.jms.server.mbean.JMSDestinationStatsImpl;
import jeus.jms.server.mbean.JMSResource;
import jeus.jms.server.mbean.stats.JMSEndpointStatsImpl;
import jeus.jms.server.message.MessageMonitor;
import jeus.jms.server.message.MessageStatsProvider;
import jeus.jms.server.message.ServerMessage;
import jeus.jms.server.persistence.StorageTransactionContext;
import jeus.jms.server.transaction.TransactionalWorks;
import jeus.jms.server.util.MessageLifecycle;
import jeus.jms.server.util.ServerSerialExecutable;
import jeus.util.LinkedHashMap;
import jeus.util.concurrent.SynchronizedBoolean;
import jeus.util.concurrent.SynchronizedInt;
import jeus.util.concurrent50.concurrent.Executor;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public abstract class DestinationManager
implements TransactedDestination,
MessageMonitor,
Takeoverable {
    protected String managerName;
    protected SynchronizedBoolean closed;
    private Set participating;
    protected SynchronizedInt current;
    protected int highMark;
    protected int lowMark;
    protected int limit;
    protected int consumerLimit;
    protected final String exportName;
    protected final JeusDestination destination;
    protected DistributionExecutable executable;
    protected SerialExecutor executor;
    protected MessageStatsProvider stats;
    protected JMSDestinationResource resource;
    protected ClusterCallbackManager callbacks;
    protected DestinationMessageManager messageManager;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms.server.manager");
    protected Map pendingQueue;

    DestinationManager(JeusDestination destination) {
        this.lowMark = this.highMark = Integer.MAX_VALUE;
        this.limit = this.highMark;
        this.pendingQueue = Collections.synchronizedMap(new LinkedHashMap());
        this.destination = destination;
        this.exportName = destination.getExportName();
    }

    void initialize() {
        this.callbacks = new ClusterCallbackManager();
        this.executable = new DistributionExecutable();
        this.executor = new SerialExecutor((Executor)ThreadPoolManager.getThreadPool());
        this.stats = new MessageStatsProvider();
        this.current = new SynchronizedInt(0);
        this.closed = new SynchronizedBoolean(false);
        this.limit = this.destination.getLimit();
        this.lowMark = this.destination.getLowMark();
        this.highMark = this.destination.getHighMark();
        this.consumerLimit = this.destination.getConsumerLimit();
    }

    void activated(SubscriptionManager subscription) {
    }

    public int getQueuedWorkSize() {
        return this.executable.queuedWorks();
    }

    public void checkUpdatable(byte type) throws JMSException {
        this.checkTransacted();
        if (this.destination.getType() != type) {
            throw new InvalidDestinationException("impossible to change type of active destination");
        }
    }

    public void checkUpperLayer() {
    }

    public void update(JeusDestination destination) throws JMSException {
    }

    public void setupRelay() throws JMSException {
        List relays = this.destination.getRelays();
        if (relays == null || relays.isEmpty()) {
            return;
        }
        byte relayType = this.destination.getRelayType();
        for (String peerName : relays) {
            if (peerName.equals(ClusterManager.LOCAL_BROKER_NAME)) continue;
            ClusteredPeer peer = ClusterManager.getClusterPeer(peerName);
            SubscriptionManager subscriber = this.createSubscriptionManager(peer, relayType, peerName);
            peer.addClusteredSubscription(subscriber);
        }
    }

    abstract SubscriptionManager createSubscriptionManager(SubscriptionContext var1, byte var2, String var3) throws JMSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(ServerMessage message) {
        try {
            this.produce(message);
        }
        catch (JMSException ex) {
            block4: {
                try {
                    if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._6131_LEVEL)) break block4;
                    LogUtils.log(logger, JeusMessage_JMS5._6131_LEVEL, JeusMessage_JMS5._6131, new Object[]{message, this, ex.getMessage()});
                }
                catch (Throwable throwable) {
                    message.messageEvent(message.isScheduled() ? (byte)1 : 0);
                    throw throwable;
                }
            }
            message.messageEvent(message.isScheduled() ? (byte)1 : 0);
        }
        message.messageEvent(message.isScheduled() ? (byte)1 : 0);
    }

    public void startDistribution() {
        if (!this.closed.get()) {
            this.executor.execute(this.executable);
        }
    }

    public void produce(ServerMessage message) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6132_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6132_LEVEL, JeusMessage_JMS5._6132, new Object[]{message, this});
        }
        try {
            this.prepareProduce(null, message);
            this.commitProduce(message);
        }
        catch (JMSException e) {
            this.rollbackProduce(message);
            throw e;
        }
    }

    public boolean prepareProduce(StorageTransactionContext context, ServerMessage message) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6133_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6133_LEVEL, JeusMessage_JMS5._6133, message);
        }
        this.checkClosed();
        this.checkCapacity();
        message.setId(StorageManager.getNextMessageID(message.getMessageType()));
        message.setDestinationEventListener(this);
        message.setQueuedTime(System.currentTimeMillis());
        if (!message.isPersisted() && this.needPersistent(message)) {
            if (context != null) {
                return this.messageManager.prepare(context, message, this.destination.getVersion());
            }
            return this.messageManager.prepare(message, this.destination.getVersion());
        }
        return false;
    }

    public void commitProduce(ServerMessage message) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6134_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6134_LEVEL, JeusMessage_JMS5._6134, message.getMessageID());
        }
        this.messageManager.commit(message);
    }

    public void rollbackProduce(ServerMessage message) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6135_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6135_LEVEL, JeusMessage_JMS5._6135, message.getMessageID());
        }
        message.setId(-1L);
        message.setDestinationEventListener(null);
        message.setQueuedTime(-1L);
        this.messageManager.rollback(message);
    }

    public void recoveredProduce(ServerMessage message, byte lifeCycle) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6136_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6136_LEVEL, JeusMessage_JMS5._6136, new Object[]{message, MessageLifecycle.getStringValue(lifeCycle)});
        }
        message.setDestinationEventListener(this);
        switch (lifeCycle) {
            case 1: {
                Scheduler.scheduleMessageEventTo(message, (byte)8, message.getScheduledTime());
                break;
            }
            case 8: {
                message.endDistribute();
                break;
            }
            case 2: {
                this.executable.startWork(message);
                break;
            }
            case 4: {
                this.pendingQueue.put(message.getMessageID(), message);
                break;
            }
            case 16: {
                this.executable.dequeueMessage(message);
            }
        }
    }

    public void messageEvent(ServerMessage message, byte event) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6137_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6137_LEVEL, JeusMessage_JMS5._6137, new Object[]{MessageEvent.getEventType(event), message.getMessageID(), this});
        }
        switch (event) {
            case 0: {
                this.messageArrived(message);
                break;
            }
            case 1: {
                this.messageScheduled(message);
                break;
            }
            case 6: {
                this.messageCompleted(message);
                break;
            }
            case 2: {
                this.messageDistributed(message);
                break;
            }
            case 3: {
                this.messageNotDistributed(message);
                break;
            }
            case 7: {
                this.messageNotDistributedLocal(message);
                break;
            }
            case 20: {
                this.messageExpired(message);
                break;
            }
            case 40: {
                this.messageFailed(message);
                break;
            }
        }
    }

    void messageArrived(ServerMessage message) {
        message = message.getShallowCopy();
        this.changeMemoryUsage(message.occupied());
        this.stats.messageArrived(message);
        this.executable.enqueueWork(message);
        this.executor.execute(this.executable);
    }

    void messageScheduled(ServerMessage message) {
        this.messageManager.scheduled(message);
    }

    void messageCompleted(ServerMessage message) {
        this.stats.messageDelivered(message);
        this.messageManager.completed(message);
    }

    void messageDistributed(ServerMessage message) {
        this.messageManager.distributed(message);
    }

    void messageNotDistributed(ServerMessage message) {
    }

    void messageNotDistributedLocal(ServerMessage message) {
    }

    void messageExpired(ServerMessage message) {
        this.messageManager.expired(message);
        this.stats.messageExpired(message);
    }

    void messageFailed(ServerMessage message) {
        DestinationManager manager = DestinationUtil.getDeadLetterQueue();
        manager.enqueue(message);
    }

    abstract void registerMBean(JMSResource var1) throws JMSException;

    abstract boolean distribute(ServerMessage var1);

    abstract boolean needPersistent(ServerMessage var1);

    abstract SubscriptionManager addSubscriber(SubscriptionContext var1, long var2, String var4, boolean var5, boolean var6) throws JMSException;

    abstract void removeSubscriber(long var1);

    public abstract boolean isQueue();

    public abstract List getJMSConsumers();

    public abstract byte getDistributionPolicy();

    public abstract void refresh();

    public abstract void shutdown();

    public abstract void shutdownForced();

    void clearResources() {
        this.unbindDestination();
        this.destoryMBean();
    }

    void bindDestination() throws JMSException {
        AdministeredObjectBinder.rebind(this.exportName, this.destination);
    }

    void unbindDestination() {
        AdministeredObjectBinder.unbindGracefully(this.exportName);
    }

    private void destoryMBean() {
        if (this.resource != null) {
            this.resource.destroyMBean();
            this.resource = null;
        }
    }

    public void registerCallback(int consumerID, JMSBaseEntry entry) {
        this.callbacks.registerCallback(consumerID, entry);
        this.callbacks.start();
    }

    public boolean receiverRegistable() {
        return true;
    }

    public synchronized void enlisted(TransactionalWorks branch) {
        if (this.participating == null) {
            this.participating = new HashSet();
        }
        this.participating.add(branch);
    }

    public synchronized void delisted(TransactionalWorks branch) {
        if (this.participating == null) {
            return;
        }
        this.participating.remove(branch);
    }

    private synchronized void checkTransacted() throws TransactionInProgressException {
        if (this.participating != null && !this.participating.isEmpty()) {
            throw new TransactionInProgressException("destination is particiating in transaction");
        }
    }

    public void changeMemoryUsage(int change) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6138_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6138_LEVEL, JeusMessage_JMS5._6138, new Object[]{this, this.current.get() + (change > 0 ? " + " : " - ") + Math.abs(change), new Integer(this.current.get() + change)});
        }
        this.current.increment(change);
    }

    public boolean exceedLowMark() {
        return this.current.get() >= this.lowMark;
    }

    public boolean exceedHighMark() {
        return this.current.get() >= this.highMark;
    }

    public boolean exceedLimit() {
        return this.current.get() >= this.limit;
    }

    public void checkClosed() throws InvalidDestinationException {
        if (this.closed.get()) {
            throw new InvalidDestinationException("Destination is already closed");
        }
    }

    public void checkCapacity() throws ResourceAllocationException {
        if (this.exceedLimit()) {
            throw new ResourceAllocationException("destinaion " + this + " is overflowing limit capacity " + this.limit);
        }
    }

    public JeusDestination getDestination() {
        return this.destination;
    }

    public String getDestinationName() {
        return this.destination.getLocalName();
    }

    public long getId() {
        return this.destination.getId();
    }

    public ObjectName getObjectName() {
        return this.resource.getObjectName();
    }

    public boolean isCosed() {
        return this.closed.get();
    }

    public long getPendingMessageCount() {
        if (this.stats != null) {
            this.refresh();
            return this.stats.getPendingMessageCount().getCount();
        }
        return 0L;
    }

    public long getMessageCount() {
        return this.stats.getMessageCount().getCount();
    }

    public long getExpiredMessageCount() {
        return this.stats.getExpiredMessageCount().getCount();
    }

    public long getMessageWaitMaxTime() {
        return this.stats.getMessageWaitTime().getMaxTime();
    }

    public long getMessageWaitMinTime() {
        return this.stats.getMessageWaitTime().getMinTime();
    }

    public long getMessageWaitTotalTime() {
        return this.stats.getMessageWaitTime().getTotalTime();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DestinationManager)) {
            return false;
        }
        DestinationManager another = (DestinationManager)obj;
        return this.destination.equals(another.destination);
    }

    public String toString() {
        return this.managerName;
    }

    public JMSEndpointStatsImpl resetMessageStats() {
        return this.stats.createTemporaryStats(new JMSDestinationStatsImpl());
    }

    class DistributionExecutable
    extends ServerSerialExecutable {
        DistributionExecutable() {
        }

        public boolean execute(ServerMessage message) {
            return DestinationManager.this.distribute(message);
        }

        public boolean postExecution(ServerMessage message, int result) {
            message.messageEvent(result == 0 ? (byte)2 : 3);
            return super.postExecution(message, result);
        }
    }
}

