/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.xml.bind.JAXBException;
import jeus.jms.common.DestinationConstant;
import jeus.jms.common.destination.DestinationIdentity;
import jeus.jms.common.destination.JeusDestination;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.server.manager.ClusterManager;
import jeus.jms.server.manager.DestinationFactory;
import jeus.jms.server.manager.DestinationManager;
import jeus.jms.server.manager.QueueManager;
import jeus.jms.server.manager.StorageManager;
import jeus.jms.server.manager.TopicManager;
import jeus.jms.server.mbean.JMSResource;
import jeus.jms.server.persistence.DestinationArchive;
import jeus.jms.server.persistence.Storage;
import jeus.jms.server.persistence.StorageException;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;
import jeus.xml.binding.jeusDD.DestinationType;
import jeus.xml.binding.jeusDD.DestinationTypeType;
import jeus.xml.binding.jeusDD.ObjectFactory;

public class DestinationUtil
implements DestinationConstant {
    private static JMSResource parent;
    private static DestinationArchive dmArchive;
    private static Map indexMap;
    private static Map destinations;
    private static Map invalidDestinations;
    protected static final JeusLogger logger;

    public static void init(JMSResource resource) {
        parent = resource;
        dmArchive = StorageManager.getDestinationStorage();
    }

    public static DestinationManager getDeadLetterQueue() {
        return DestinationUtil.findLocalDestinationManager(ClusterManager.LOCAL_BROKER_NAME + "_JMS_DLQ");
    }

    public static synchronized void removeDestination(String name) throws InvalidDestinationException {
        DestinationManager manager;
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6761_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6761_LEVEL, JeusMessage_JMS5._6761, name);
        }
        if ((manager = (DestinationManager)destinations.remove(name)) == null) {
            throw new InvalidDestinationException("unable to find destination " + name);
        }
        indexMap.remove(new Long(manager.getId()));
        manager.shutdownForced();
        dmArchive.delete(manager.getDestination());
    }

    private static synchronized void removeDestination(DestinationManager manager) {
        block2: {
            try {
                DestinationUtil.removeDestination(manager.getDestinationName());
            }
            catch (InvalidDestinationException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._6762_LEVEL)) break block2;
                LogUtils.log(logger, JeusMessage_JMS5._6762_LEVEL, JeusMessage_JMS5._6762, e.getMessage());
            }
        }
    }

    public static synchronized DestinationManager createDestinationManager(JeusDestination destination) throws JMSException {
        DestinationManager manager;
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6763_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6763_LEVEL, JeusMessage_JMS5._6763, destination.getLocalName());
        }
        if ((manager = (DestinationManager)destinations.get(destination.getLocalName())) != null) {
            throw new InvalidDestinationException("destination " + destination.getLocalName() + " is already exists");
        }
        long id = dmArchive.createId();
        destination.setId(id);
        try {
            dmArchive.persist(destination);
            manager = DestinationFactory.createDestinationManager(destination);
            manager.registerMBean(parent);
            manager.setupRelay();
            destinations.put(manager.getDestinationName(), manager);
            indexMap.put(new Long(manager.getId()), manager);
        }
        catch (StorageException e) {
            if (manager != null) {
                DestinationUtil.removeDestination(manager);
            }
            throw JMSExceptionFactory.createJMSException("failed to persist destination.", (Exception)((Object)e));
        }
        return manager;
    }

    public static synchronized DestinationManager restoreDestinationManager(JeusDestination destination) throws JMSException {
        if (!destination.isValid()) {
            invalidDestinations.put(new Long(destination.getId()), destination);
            return null;
        }
        DestinationManager manager = DestinationFactory.createDestinationManager(destination);
        manager.registerMBean(parent);
        manager.setupRelay();
        destinations.put(destination.getLocalName(), manager);
        indexMap.put(new Long(manager.getId()), manager);
        return manager;
    }

    public static synchronized long getDestinationId(DestinationIdentity identity) {
        try {
            DestinationManager mgr = DestinationUtil.getDestinationManager(identity);
            return mgr.getId();
        }
        catch (InvalidDestinationException e) {
            return -1L;
        }
    }

    public static synchronized DestinationManager findLocalDestinationManager(String destName) {
        return (DestinationManager)destinations.get(destName);
    }

    public static synchronized TopicManager findLocalTopicManager(String destName) {
        DestinationManager manager = DestinationUtil.findLocalDestinationManager(destName);
        if (manager == null || manager.isQueue()) {
            return null;
        }
        return (TopicManager)manager;
    }

    public static synchronized DestinationManager getLocalDestinationManager(String destName) throws InvalidDestinationException {
        DestinationManager manager = DestinationUtil.findLocalDestinationManager(destName);
        if (manager == null) {
            throw new InvalidDestinationException("no such destination[" + destName + "]");
        }
        return manager;
    }

    public static synchronized TopicManager getLocalTopicManager(String destName) throws InvalidDestinationException {
        DestinationManager manager = DestinationUtil.getLocalDestinationManager(destName);
        if (manager.isQueue()) {
            throw new InvalidDestinationException("invalid type(queue) destination");
        }
        return (TopicManager)manager;
    }

    public static synchronized QueueManager getLocalQueueManager(String destName) throws InvalidDestinationException {
        DestinationManager manager = DestinationUtil.getLocalDestinationManager(destName);
        if (!manager.isQueue()) {
            throw new InvalidDestinationException("invalid type(topic) destination");
        }
        return (QueueManager)manager;
    }

    public static synchronized DestinationManager getDestinationManager(DestinationIdentity identity) throws InvalidDestinationException {
        DestinationManager manager = (DestinationManager)destinations.get(identity.getLocalName());
        if (manager == null) {
            throw new InvalidDestinationException("no such destination[" + identity + "]");
        }
        return manager;
    }

    public static synchronized DestinationManager getDestinationManager(String localName) throws InvalidDestinationException {
        DestinationManager manager = (DestinationManager)destinations.get(localName);
        if (manager == null) {
            throw new InvalidDestinationException("no such destination[" + localName + "]");
        }
        return manager;
    }

    public static synchronized boolean checkDestination(long id) {
        return indexMap.containsKey(new Long(id));
    }

    public static synchronized DestinationManager getDestinationManager(long id) throws InvalidDestinationException {
        DestinationManager manager = (DestinationManager)indexMap.get(new Long(id));
        if (manager == null) {
            throw new InvalidDestinationException("no such destination[ID:" + id + "]");
        }
        return manager;
    }

    public static synchronized QueueManager getQueueManager(long id) throws InvalidDestinationException {
        DestinationManager manager = DestinationUtil.getDestinationManager(id);
        if (!manager.isQueue()) {
            throw new InvalidDestinationException("invalid type(topic) destination");
        }
        return (QueueManager)manager;
    }

    public static synchronized TopicManager getTopicManager(DestinationIdentity identity) throws InvalidDestinationException {
        DestinationManager manager = DestinationUtil.getDestinationManager(identity);
        if (manager.isQueue()) {
            throw new InvalidDestinationException("invalid type(queue) destination");
        }
        return (TopicManager)manager;
    }

    public static synchronized QueueManager getQueueManager(DestinationIdentity identity) throws InvalidDestinationException {
        DestinationManager manager = DestinationUtil.getDestinationManager(identity);
        if (!manager.isQueue()) {
            throw new InvalidDestinationException("invalid type(topic) destination");
        }
        return (QueueManager)manager;
    }

    public static synchronized void startSweeping() {
        Storage storage = dmArchive.getStorage();
        if (storage.isDeleteInvalidDestinations()) {
            for (JeusDestination destination : invalidDestinations.values()) {
                try {
                    storage.deleteDestination(destination);
                }
                catch (StorageException e) {
                    if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._6764_LEVEL)) continue;
                    LogUtils.log(logger, JeusMessage_JMS5._6764_LEVEL, JeusMessage_JMS5._6764, destination.getLocalName(), (Throwable)((Object)e));
                }
            }
        }
        for (DestinationManager manager : destinations.values()) {
            JeusDestination destination = manager.getDestination();
            if (!destination.isRecovered()) continue;
            try {
                storage.deleteStaleMessages(manager.getDestination());
            }
            catch (StorageException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._6765_LEVEL)) continue;
                LogUtils.log(logger, JeusMessage_JMS5._6765_LEVEL, JeusMessage_JMS5._6765, destination.getLocalName(), (Throwable)((Object)e));
            }
        }
    }

    public static synchronized void startDistribution() {
        for (DestinationManager manager : destinations.values()) {
            manager.startDistribution();
        }
    }

    public static synchronized void shutdown() {
        Collection collection = destinations.values();
        DestinationManager[] managers = collection.toArray(new DestinationManager[collection.size()]);
        for (int i = 0; i < managers.length; ++i) {
            DestinationManager manager = managers[i];
            manager.shutdown();
        }
        invalidDestinations.clear();
        destinations.clear();
        indexMap.clear();
    }

    public static synchronized List getDigest() {
        ArrayList<String> result = new ArrayList<String>();
        for (DestinationManager manager : destinations.values()) {
            result.add(manager.toString());
        }
        return result;
    }

    public static synchronized DestinationManager[] getAllDestinationManagers() {
        return destinations.values().toArray(new DestinationManager[0]);
    }

    public static DestinationType createDestinationType(byte type, String name, String exportName, String brokerNameForServerRouting) throws JMSException {
        try {
            ObjectFactory factory = new ObjectFactory();
            DestinationType descriptor = factory.createDestinationType();
            if (81 == type) {
                descriptor.setType(DestinationTypeType.fromValue((String)"queue"));
            } else {
                descriptor.setType(DestinationTypeType.fromValue((String)"topic"));
            }
            descriptor.setName(name);
            if (name == null) {
                exportName = name;
            }
            descriptor.setExportName(exportName);
            descriptor.setBrokerName(brokerNameForServerRouting);
            descriptor.fillDefault();
            return descriptor;
        }
        catch (JAXBException e) {
            throw new JMSException(e.getMessage());
        }
    }

    static {
        indexMap = new HashMap();
        destinations = new TreeMap();
        invalidDestinations = new HashMap();
        logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    }
}

