/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jms.JMSException;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.util.ISerialExecutable;
import jeus.jms.server.manager.AcknowledgeQueue;
import jeus.jms.server.manager.MessageRequest;
import jeus.jms.server.manager.MessageSelector;
import jeus.jms.server.manager.MessageSource;
import jeus.jms.server.message.ServerMessage;
import jeus.util.LinkedHashMap;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

abstract class DispatchMessageQueue
implements ISerialExecutable {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    private boolean executing;
    private boolean suspend;
    final LinkedHashMap queue = new LinkedHashMap();
    final AcknowledgeQueue ackQueue;
    private LinkedList requests;

    DispatchMessageQueue(int maxPendingLimit, float resumeDispatchFactor) {
        this.ackQueue = new AcknowledgeQueue(this, maxPendingLimit, resumeDispatchFactor);
        this.requests = new LinkedList();
    }

    void consumerClosed() {
        this.cancelSyncRequests();
    }

    void handleSyncRequest(MessageRequest request) {
        ServerMessage message;
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6221_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6221_LEVEL, JeusMessage_JMS5._6221, request);
        }
        if ((message = this.acquireSyncMessage(request)) != null) {
            request.execute(message);
        }
    }

    void handleSyncRequest(MessageRequest request, MessageSource source) {
        ServerMessage message;
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6222_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6222_LEVEL, JeusMessage_JMS5._6222, request);
        }
        if ((message = this.acquireSyncMessage(request, source)) != null) {
            request.execute(message);
        }
    }

    ServerMessage acquireSyncMessage(MessageRequest request) {
        return request.isBlockingRequest() ? this.checkQueuedMessage(request) : this.checkQueuedMessage();
    }

    private ServerMessage acquireSyncMessage(MessageRequest request, MessageSource source) {
        return request.isBlockingRequest() ? this.checkQueuedMessage(request, source) : this.checkQueuedMessage(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean syncRequested() {
        LinkedHashMap linkedHashMap = this.queue;
        synchronized (linkedHashMap) {
            return !this.requests.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelSyncRequests() {
        LinkedHashMap linkedHashMap = this.queue;
        synchronized (linkedHashMap) {
            this.requests.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessageRequest acquireSyncRequest(ServerMessage message, boolean recover) {
        LinkedHashMap linkedHashMap = this.queue;
        synchronized (linkedHashMap) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6223_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6223_LEVEL, JeusMessage_JMS5._6223, this.requests);
            }
            if (this.requests.isEmpty()) {
                this.enqueue(message, recover);
                return null;
            }
            return this.checkSyncRequest(message, recover);
        }
    }

    private MessageRequest checkSyncRequest(ServerMessage message, boolean recover) {
        long current = System.currentTimeMillis();
        Iterator it = this.requests.iterator();
        while (it.hasNext()) {
            MessageRequest request = (MessageRequest)it.next();
            if (request.isValid() && !request.isSelectedMessage(message)) continue;
            it.remove();
            if (!request.isApplicable(message, current) || !request.commit(message, current)) continue;
            return request;
        }
        this.enqueue(message, recover);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerMessage checkQueuedMessage() {
        LinkedHashMap linkedHashMap = this.queue;
        synchronized (linkedHashMap) {
            return this.queue.isEmpty() ? null : this.dequeueEldestMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerMessage checkQueuedMessage(MessageRequest request) {
        LinkedHashMap linkedHashMap = this.queue;
        synchronized (linkedHashMap) {
            ServerMessage message;
            ServerMessage serverMessage = message = this.queue.isEmpty() ? null : this.dequeueEldestMessage(request);
            if (message == null) {
                this.addSyncRequest(request);
            }
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerMessage checkQueuedMessage(MessageSource source) {
        LinkedHashMap linkedHashMap = this.queue;
        synchronized (linkedHashMap) {
            return this.queue.isEmpty() ? source.acquireMessage() : this.dequeueEldestMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerMessage checkQueuedMessage(MessageRequest request, MessageSource source) {
        LinkedHashMap linkedHashMap = this.queue;
        synchronized (linkedHashMap) {
            ServerMessage message;
            ServerMessage serverMessage = message = this.queue.isEmpty() ? source.acquireMessage() : this.dequeueEldestMessage();
            if (message == null) {
                this.addSyncRequest(request);
            }
            return message;
        }
    }

    private void addSyncRequest(MessageRequest request) {
        this.requests.add(request);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6224_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6224_LEVEL, JeusMessage_JMS5._6224, new Object[]{request, this.requests});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueAcknowledge(ServerMessage message) {
        AcknowledgeQueue acknowledgeQueue = this.ackQueue;
        synchronized (acknowledgeQueue) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6225_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6225_LEVEL, JeusMessage_JMS5._6225, message.getMessageID());
            }
            this.ackQueue.put(message.getMessageID(), message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recoverAcknowledge(ServerMessage message) {
        AcknowledgeQueue acknowledgeQueue = this.ackQueue;
        synchronized (acknowledgeQueue) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6226_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6226_LEVEL, JeusMessage_JMS5._6226, message.getMessageID());
            }
            this.ackQueue.recover(message.getMessageID(), message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recoverAcknowledges(LinkedHashMap unacked) {
        AcknowledgeQueue acknowledgeQueue = this.ackQueue;
        synchronized (acknowledgeQueue) {
            this.ackQueue.recover(unacked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerMessage findAcknowledge(MessageID messageID) {
        AcknowledgeQueue acknowledgeQueue = this.ackQueue;
        synchronized (acknowledgeQueue) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6227_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6227_LEVEL, JeusMessage_JMS5._6227, messageID);
            }
            return (ServerMessage)this.ackQueue.get(messageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerMessage removeAcknowledge(MessageID messageID) {
        AcknowledgeQueue acknowledgeQueue = this.ackQueue;
        synchronized (acknowledgeQueue) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6228_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6228_LEVEL, JeusMessage_JMS5._6228, messageID);
            }
            ServerMessage msg = (ServerMessage)this.ackQueue.remove(messageID);
            return msg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnUnackedMessages() {
        AcknowledgeQueue acknowledgeQueue = this.ackQueue;
        synchronized (acknowledgeQueue) {
            this.recoverMessages(this.ackQueue);
            this.ackQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAcknowledges() {
        AcknowledgeQueue acknowledgeQueue = this.ackQueue;
        synchronized (acknowledgeQueue) {
            this.ackQueue.clear();
        }
    }

    int clearAll() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6235_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6235_LEVEL, JeusMessage_JMS5._6235);
        }
        this.clearAcknowledges();
        return this.clearQueuedMessage();
    }

    private ServerMessage dequeueEldestMessage() {
        ServerMessage message = (ServerMessage)this.queue.removeEldestValue();
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6229_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6229_LEVEL, JeusMessage_JMS5._6229, message != null ? message.getMessageID() : null);
        }
        return message;
    }

    private ServerMessage dequeueEldestMessage(MessageSelector selector) {
        Iterator it = this.queue.values().iterator();
        while (it.hasNext()) {
            ServerMessage message = (ServerMessage)it.next();
            if (!selector.isSelectedMessage(message)) continue;
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6230_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6230_LEVEL, JeusMessage_JMS5._6230, message != null ? message.getMessageID() : null);
            }
            it.remove();
            return message;
        }
        return null;
    }

    private ServerMessage enqueue(ServerMessage message, boolean recover) {
        return recover ? this.recoverMessage(message) : this.enqueueMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerMessage enqueueMessage(ServerMessage message) {
        LinkedHashMap linkedHashMap = this.queue;
        synchronized (linkedHashMap) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6231_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6231_LEVEL, JeusMessage_JMS5._6231, message.getMessageID());
            }
            return (ServerMessage)this.queue.put((Object)message.getMessageID(), (Object)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerMessage recoverMessage(ServerMessage message) {
        LinkedHashMap linkedHashMap = this.queue;
        synchronized (linkedHashMap) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6232_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6232_LEVEL, JeusMessage_JMS5._6232, message.getMessageID());
            }
            message.recoverContents();
            return (ServerMessage)this.queue.recover((Object)message.getMessageID(), (Object)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverMessages(LinkedHashMap unacked) {
        LinkedHashMap linkedHashMap = this.queue;
        synchronized (linkedHashMap) {
            this.queue.recover(unacked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerMessage removeMessage(MessageID messageID) {
        LinkedHashMap linkedHashMap = this.queue;
        synchronized (linkedHashMap) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6233_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6233_LEVEL, JeusMessage_JMS5._6233, messageID);
            }
            return (ServerMessage)this.queue.remove((Object)messageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsMessage(MessageID messageID) {
        LinkedHashMap linkedHashMap = this.queue;
        synchronized (linkedHashMap) {
            return this.queue.containsKey((Object)messageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int clearQueuedMessage() {
        LinkedHashMap linkedHashMap = this.queue;
        synchronized (linkedHashMap) {
            int n;
            try {
                n = this.queue.size();
            }
            catch (Throwable throwable) {
                this.queue.clear();
                throw throwable;
            }
            this.queue.clear();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getQueueSize() {
        LinkedHashMap linkedHashMap = this.queue;
        synchronized (linkedHashMap) {
            return this.queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEmpty() {
        LinkedHashMap linkedHashMap = this.queue;
        synchronized (linkedHashMap) {
            return this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection removeQueuedMessages() {
        LinkedHashMap linkedHashMap = this.queue;
        synchronized (linkedHashMap) {
            ArrayList arrayList;
            try {
                arrayList = new ArrayList(this.queue.values());
            }
            catch (Throwable throwable) {
                this.queue.clear();
                throw throwable;
            }
            this.queue.clear();
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getQueue() {
        LinkedHashMap linkedHashMap = this.queue;
        synchronized (linkedHashMap) {
            return new ArrayList(this.queue.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        LinkedHashMap linkedHashMap = this.queue;
        synchronized (linkedHashMap) {
            return this.suspend;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuspend(boolean suspend) {
        LinkedHashMap linkedHashMap = this.queue;
        synchronized (linkedHashMap) {
            this.suspend = suspend;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExecuting(boolean execute) {
        LinkedHashMap linkedHashMap = this.queue;
        synchronized (linkedHashMap) {
            this.executing = execute;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExecuting() {
        LinkedHashMap linkedHashMap = this.queue;
        synchronized (linkedHashMap) {
            return this.executing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkExecutor() {
        LinkedHashMap linkedHashMap = this.queue;
        synchronized (linkedHashMap) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6234_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6234_LEVEL, JeusMessage_JMS5._6234, new Object[]{Thread.currentThread(), !this.suspend && !this.queue.isEmpty() && !this.executing});
            }
            return !this.suspend && !this.queue.isEmpty() && this.checkExecution(false, true);
        }
    }

    private boolean checkExecution(boolean assume, boolean newValue) {
        if (this.executing != assume) {
            return false;
        }
        this.executing = newValue;
        return true;
    }

    void startExecution() {
        if (this.checkExecutor()) {
            this.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerMessage getExecutableMessage(boolean next) {
        LinkedHashMap linkedHashMap = this.queue;
        synchronized (linkedHashMap) {
            ServerMessage message = next && !this.suspend ? this.dequeueEldestMessage() : null;
            this.executing = message != null;
            return message;
        }
    }

    public void run() {
        ServerMessage message = this.getExecutableMessage(true);
        while (message != null) {
            boolean next = this.startWork(message);
            message = this.getExecutableMessage(next);
        }
        this.workCompleted();
    }

    boolean startWork(ServerMessage message) {
        int result;
        this.preExecution(message);
        try {
            result = this.execute(message) ? 0 : 1;
        }
        catch (JMSException e) {
            this.exception(message, e);
            result = 2;
        }
        catch (Throwable t) {
            this.failed(message, t);
            result = 3;
        }
        return this.postExecution(message, result);
    }

    abstract void preExecution(ServerMessage var1);

    abstract boolean execute(ServerMessage var1) throws JMSException;

    abstract boolean postExecution(ServerMessage var1, int var2);

    abstract void exception(ServerMessage var1, JMSException var2);

    abstract void failed(ServerMessage var1, Throwable var2);

    abstract void workCompleted();
}

