/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.ResourceAllocationException;
import javax.management.InstanceAlreadyExistsException;
import jeus.jms.common.destination.JeusDestination;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.MessageInfo;
import jeus.jms.common.message.selector.MessageCheck;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.MessageHandler;
import jeus.jms.server.JMSClusterEntry;
import jeus.jms.server.manager.DestinationManager;
import jeus.jms.server.manager.DestinationQueue;
import jeus.jms.server.manager.IndirectMessageRequest;
import jeus.jms.server.manager.MessageRequest;
import jeus.jms.server.manager.MessageSink;
import jeus.jms.server.manager.QueueMessageManager;
import jeus.jms.server.manager.SubscriptionContext;
import jeus.jms.server.manager.SubscriptionManager;
import jeus.jms.server.manager.SubscriptionUtil;
import jeus.jms.server.manager.TakeoverUtil;
import jeus.jms.server.mbean.JMSQueueDestinationResource;
import jeus.jms.server.mbean.JMSResource;
import jeus.jms.server.message.ServerMessage;
import jeus.jms.server.persistence.StorageException;
import jeus.jms.server.util.ExecutionCycle;
import jeus.util.LinkedHashMap;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public abstract class QueueManager
extends DestinationManager {
    private DestinationQueue msgQueue;

    public void requeuePendingMessage(ServerMessage message, boolean isNewDeliver) {
        message.endDistribute();
        if (!isNewDeliver) {
            message.setJMSRedelivered(true);
        }
        this.messageManager.requeue(message);
        this.messageArrived(message);
    }

    public QueueManager(JeusDestination queue) {
        super(queue);
        this.initialize();
    }

    void initialize() {
        super.initialize();
        this.msgQueue = new DestinationQueue(this.destination);
        this.messageManager = new QueueMessageManager(this.destination);
    }

    void registerMBean(JMSResource parent) throws JMSException {
        this.bindDestination();
        try {
            this.resource = JMSQueueDestinationResource.createMBean(this.destination.getLocalName(), parent, this);
            this.stats.init(this.resource.getinitialStats());
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            this.shutdown();
            throw new ResourceAllocationException("exception occurred creating mbean for " + this);
        }
    }

    SubscriptionManager createSubscriptionManager(SubscriptionContext subscriptionContext, byte relayType, String peerName) throws JMSException {
        return SubscriptionUtil.addSubscription(subscriptionContext, this, null, false, true);
    }

    void trigger() {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6001_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6001_LEVEL, JeusMessage_JMS5._6001, this);
        }
        this.executable.recover(this.msgQueue.removeQueuedMessages());
        this.executor.execute(this.executable, !this.executable.isEmpty());
        this.callbacks.resume();
    }

    void activated(SubscriptionManager subscription) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6002_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6002_LEVEL, JeusMessage_JMS5._6002, new Object[]{this, subscription});
        }
        if (subscription.isDispatchable()) {
            this.executable.recover(this.msgQueue.removeQueuedMessages());
            this.executor.execute(this.executable, !this.executable.isEmpty());
        }
        this.callbacks.resume();
    }

    public void shutdownForced() {
        if (!this.closed.commit(false, true)) {
            return;
        }
        this.msgQueue.setSuspend(true);
        this.msgQueue.returnUnackedMessages();
        for (ServerMessage message : this.msgQueue.removeQueuedMessages()) {
            this.messageManager.completed(message);
        }
        this.msgQueue.clearAll();
        this.clearResources();
    }

    boolean needPersistent(ServerMessage message) {
        return message.isPersistent() || this.current.get() > this.highMark;
    }

    void messageNotDistributed(ServerMessage message) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6003_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6003_LEVEL, JeusMessage_JMS5._6003, new Object[]{this, message.getMessageID()});
        }
        this.msgQueue.dispatchMessage(message, false);
    }

    void messageNotDistributedLocal(ServerMessage message) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6004_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6004_LEVEL, JeusMessage_JMS5._6004, new Object[]{this, message.getMessageID()});
        }
        this.msgQueue.dispatchMessage(message, true);
    }

    ServerMessage acquireMessage(final MessageSink selector, MessageRequest request) {
        IndirectMessageRequest indirect = new IndirectMessageRequest(selector, request){

            public void execute(ServerMessage message) {
                new ExecutionCycle(){

                    public boolean execute(ServerMessage message) {
                        return selector.enqueueMessage(message);
                    }

                    public boolean postExecution(ServerMessage message, int result) {
                        message.messageEvent(result == 0 ? (byte)2 : 7);
                        return super.postExecution(message, result);
                    }
                }.startWork(message);
            }
        };
        return this.msgQueue.acquireSyncMessage(indirect);
    }

    public List browse(String selector) throws JMSException {
        this.checkClosed();
        MessageCheck check = new MessageCheck(selector);
        if (this.msgQueue.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6005_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6005_LEVEL, JeusMessage_JMS5._6005, new Object[]{this, new Integer(this.msgQueue.getQueueSize())});
        }
        ArrayList<ClientMessage> result = new ArrayList<ClientMessage>();
        List messages = this.msgQueue.getQueue();
        Iterator it = messages.iterator();
        while (it.hasNext()) {
            try {
                ServerMessage msg = (ServerMessage)it.next();
                if (!check.isSelectedMessage(msg)) continue;
                result.add(msg.getClientMessageCopy());
            }
            catch (Exception e) {
                throw JMSExceptionFactory.createJMSException("failed to browse queue " + this, e);
            }
        }
        return result;
    }

    void recoveredEnqueue(ServerMessage message) {
        this.executable.enqueueWork(message);
    }

    void recoveredDeliver(ServerMessage message) {
        message.setJMSRedelivered(true);
        this.executable.enqueueWork(message);
    }

    void messageExpired(ServerMessage message) {
        this.msgQueue.removeMessage(message.getMessageID());
        super.messageExpired(message);
    }

    void recoverMessage(ServerMessage message) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6006_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6006_LEVEL, JeusMessage_JMS5._6006, new Object[]{this, message.getMessageID()});
        }
        this.executable.recover(message);
    }

    void recoverMessages(LinkedHashMap unacked) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6007_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6007_LEVEL, JeusMessage_JMS5._6007, new Object[]{this, unacked.keySet()});
        }
        this.executable.recover(unacked.values());
    }

    void recoverAcknowledge(ServerMessage message) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6008_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6008_LEVEL, JeusMessage_JMS5._6008, new Object[]{this, message.getMessageID()});
        }
        this.msgQueue.recoverAcknowledge(message);
    }

    void recoverAcknowledges(LinkedHashMap unacked) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6009_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6009_LEVEL, JeusMessage_JMS5._6009, new Object[]{this, unacked.keySet()});
        }
        this.msgQueue.recoverAcknowledges(unacked);
    }

    public void refresh() {
        this.stats.setPendingMessageCount(this.msgQueue.getQueueSize());
    }

    public boolean isQueue() {
        return true;
    }

    public int getRemainingMessages() {
        return this.msgQueue.getQueueSize();
    }

    public int getRemainingPendingMessages() {
        return this.pendingQueue.size();
    }

    public int removeAllMessage() {
        int size;
        block3: {
            this.msgQueue.setSuspend(true);
            this.msgQueue.returnUnackedMessages();
            for (ServerMessage message : this.msgQueue.removeQueuedMessages()) {
                this.messageManager.completed(message, false);
            }
            size = this.msgQueue.clearAll();
            this.msgQueue.setSuspend(false);
            this.pendingQueue.clear();
            try {
                this.messageManager.deleteAllMessages(this.destination);
            }
            catch (StorageException e) {
                if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._6010_LEVEL)) break block3;
                LogUtils.log(logger, JeusMessage_JMS5._6010_LEVEL, JeusMessage_JMS5._6010, (Throwable)((Object)e));
            }
        }
        return size;
    }

    public void removeMessage(String id) throws JMSException {
        MessageID messageID = MessageID.parseMessageID(id);
        ServerMessage message = this.msgQueue.removeMessage(messageID);
        if (message == null) {
            throw new JMSException("not existing message " + messageID);
        }
        this.messageManager.completed(message);
    }

    public void requeuePendingMessage(String id, boolean isNewDeliver) throws JMSException {
        if (id != null) {
            MessageID messageID = MessageID.parseMessageID(id);
            ServerMessage message = (ServerMessage)this.pendingQueue.remove(messageID);
            this.requeuePendingMessage(message, isNewDeliver);
        } else {
            Iterator i = this.pendingQueue.values().iterator();
            while (i.hasNext()) {
                this.requeuePendingMessage((ServerMessage)i.next(), isNewDeliver);
            }
            this.pendingQueue.clear();
        }
    }

    public List getMessageInfo(String selector) throws JMSException {
        return this.getMessageInfoInQueue(this.msgQueue.getQueue(), selector);
    }

    public List getPendingMessageInfo(String selector) throws JMSException {
        return this.getMessageInfoInQueue(this.pendingQueue.values(), selector);
    }

    private List getMessageInfoInQueue(Collection messages, String selector) throws JMSException {
        MessageCheck check = new MessageCheck(selector);
        ArrayList<MessageInfo> result = new ArrayList<MessageInfo>();
        for (ServerMessage message : messages) {
            if (!check.isSelectedMessage(message)) continue;
            result.add(MessageInfo.createMessageInfo(message.getMessageType(), message));
        }
        return result;
    }

    public long takeover(MessageHandler handler, JMSClusterEntry activeBrokerEntry) throws Exception {
        long takeovered = this.msgQueue.getQueueSize();
        TakeoverUtil.takeover(this.msgQueue.getQueue(), handler, activeBrokerEntry);
        this.msgQueue.clearAll();
        Collection pendingMsgs = this.pendingQueue.values();
        TakeoverUtil.takeover(pendingMsgs, handler, activeBrokerEntry);
        this.pendingQueue.clear();
        return takeovered += (long)pendingMsgs.size();
    }
}

