/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import jeus.jms.server.message.MessageEventTask;
import jeus.jms.server.message.ServerMessage;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class Scheduler {
    private static long UTC_OFFSET;
    private static Timer timer;
    protected static final JeusLogger logger;

    public static synchronized MessageEventTask scheduleMessageEvent(ServerMessage message, byte event, long delay) {
        Scheduler.createTimer();
        MessageEventTask task = new MessageEventTask(message, event);
        timer.schedule((TimerTask)task, delay);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6641_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6641_LEVEL, JeusMessage_JMS5._6641, new Object[]{task, new Long(delay)});
        }
        return task;
    }

    public static synchronized MessageEventTask scheduleMessageEventTo(ServerMessage message, byte event, long due) {
        return Scheduler.scheduleMessageEvent(message, event, due - System.currentTimeMillis());
    }

    public static synchronized void scheduleTask(TimerTask task, long delay) {
        Scheduler.createTimer();
        timer.schedule(task, delay);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6642_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6642_LEVEL, JeusMessage_JMS5._6642, new Object[]{task, new Long(delay)});
        }
    }

    public static void scheduleTask(TimerTask task, long delay, long interval) {
        Scheduler.createTimer();
        timer.schedule(task, delay, interval);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6643_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6643_LEVEL, JeusMessage_JMS5._6643, new Object[]{task, new Long(delay), new Long(interval)});
        }
    }

    public static synchronized void shutdown() {
        if (timer != null) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6644_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6644_LEVEL, JeusMessage_JMS5._6644, Scheduler.class.getName());
            }
            timer.cancel();
            timer = null;
        }
    }

    private static void createTimer() {
        if (timer == null) {
            timer = new JMSTimer();
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6645_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._6645_LEVEL, JeusMessage_JMS5._6645, new Object[]{Scheduler.class.getName(), new Long(UTC_OFFSET)});
            }
        }
    }

    static {
        TimeZone time = TimeZone.getDefault();
        UTC_OFFSET = time.getRawOffset();
        logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    }

    private static class JMSTimer
    extends Timer {
        private JMSTimer() {
        }

        public void schedule(TimerTask task, long delay) {
            if (delay < 0L) {
                task.run();
            } else {
                super.schedule(task, delay);
            }
        }
    }
}

