/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import jeus.jms.common.destination.JeusQueue;
import jeus.jms.server.AbstractConsumer;
import jeus.jms.server.manager.QueueManager;
import jeus.jms.server.manager.QueueSubscriptionManager;
import jeus.jms.server.manager.SubscriptionContext;
import jeus.jms.server.manager.SubscriptionManager;
import jeus.jms.server.manager.SubscriptionUtil;
import jeus.jms.server.message.ServerMessage;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class SingleQueueManager
extends QueueManager {
    private long subscriberID;
    private SubscriptionManager manager;

    public SingleQueueManager(JeusQueue queue) {
        super(queue);
        this.managerName = "SQM[" + this.destination.getLocalName() + "]";
    }

    synchronized SubscriptionManager addSubscriber(SubscriptionContext subscriptionContext, long id, String selector, boolean noLocal, boolean cluster) throws JMSException {
        this.checkClosed();
        this.subscriberID = id;
        this.manager = new QueueSubscriptionManager(subscriptionContext, id, this, selector, cluster);
        return this.manager;
    }

    synchronized void removeSubscriber(long id) {
        if (this.subscriberID == id) {
            SubscriptionUtil.removeSubscription(id);
            this.callbacks.suspend();
            this.manager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean distribute(ServerMessage message) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6511_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6511_LEVEL, JeusMessage_JMS5._6511, new Object[]{message, this});
        }
        message.startDistribute();
        try {
            boolean bl = this.manager != null && this.manager.isActive() && this.manager.enqueueMessage(message);
            return bl;
        }
        finally {
            message.endDistribute();
        }
    }

    public synchronized void shutdown() {
        if (!this.closed.commit(false, true)) {
            return;
        }
        if (this.manager != null) {
            this.manager.shutdown();
        }
        this.clearResources();
    }

    public synchronized List getJMSConsumers() {
        AbstractConsumer consumer;
        ArrayList<AbstractConsumer> list = new ArrayList<AbstractConsumer>(1);
        if (this.manager != null && this.manager.isActive() && (consumer = this.manager.getMessageConsumer()) != null) {
            list.add(consumer);
        }
        return list;
    }

    public synchronized boolean receiverRegistable() {
        return this.manager == null || !this.manager.isActive();
    }

    public String toString() {
        String name = super.toString() + ", manager : " + this.manager;
        if (this.manager != null) {
            name = name + ", active : " + this.manager.isActive();
        }
        return name;
    }

    public byte getDistributionPolicy() {
        return 98;
    }
}

