/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.ResourceAllocationException;
import javax.management.InstanceAlreadyExistsException;
import jeus.jms.common.destination.JeusTopic;
import jeus.jms.common.util.MessageHandler;
import jeus.jms.server.AbstractConsumer;
import jeus.jms.server.JMSClusterEntry;
import jeus.jms.server.manager.DestinationManager;
import jeus.jms.server.manager.DestinationUtil;
import jeus.jms.server.manager.NonDurableTopicSubscriptionManager;
import jeus.jms.server.manager.SubscriptionContext;
import jeus.jms.server.manager.SubscriptionManager;
import jeus.jms.server.manager.SubscriptionUtil;
import jeus.jms.server.manager.Takeoverable;
import jeus.jms.server.manager.TopicMessageManager;
import jeus.jms.server.manager.TopicSubscriptionManager;
import jeus.jms.server.mbean.JMSResource;
import jeus.jms.server.mbean.JMSTopicDestinationResource;
import jeus.jms.server.message.MessageDistributor;
import jeus.jms.server.message.ServerMessage;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class TopicManager
extends DestinationManager {
    private TopicManager upper;
    private Map managers;
    private Map durables;
    private MessageDistributor distributor;

    public TopicManager(JeusTopic topic) {
        super(topic);
        this.initialize();
    }

    void initialize() {
        super.initialize();
        this.managers = new HashMap();
        this.durables = new HashMap();
        this.messageManager = new TopicMessageManager(this.destination);
        this.distributor = new MessageDistributor.SimpleTopicDistributor(this.managers);
        this.managerName = "TM[" + this.destination.getLocalName() + "]";
        this.checkUpperLayer();
    }

    void registerMBean(JMSResource parent) throws JMSException {
        this.bindDestination();
        try {
            this.resource = JMSTopicDestinationResource.createMBean(this.destination.getLocalName(), parent, this);
            this.stats.init(this.resource.getinitialStats());
        }
        catch (InstanceAlreadyExistsException e) {
            this.shutdown();
            throw new ResourceAllocationException("exception occurred creating mbean for " + this);
        }
    }

    boolean needPersistent(ServerMessage message) {
        return !this.durables.isEmpty() || this.current.get() > this.highMark;
    }

    public byte getDistributionPolicy() {
        return 99;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean distribute(ServerMessage message) {
        message.startDistribute();
        try {
            boolean bl = this.distributeMessage(message);
            return bl;
        }
        finally {
            message.endDistribute();
        }
    }

    boolean distributeMessage(ServerMessage message) {
        boolean success;
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6051_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6051_LEVEL, JeusMessage_JMS5._6051, new Object[]{message, new Integer(this.managers.size()), new Integer(this.durables.size())});
        }
        if ((success = this.distributor.distribute(message)) && this.upper != null) {
            return this.upper.distributeMessage(message);
        }
        return success;
    }

    void recoveredEnqueue(ServerMessage message) {
        this.executable.execute(message);
    }

    public boolean receiverRegistable() {
        return this.managers.size() < this.consumerLimit;
    }

    public boolean isQueue() {
        return false;
    }

    public void shutdown() {
        if (!this.closed.commit(false, true)) {
            return;
        }
        for (TopicSubscriptionManager manager : this.getSubscriptionManagers()) {
            manager.shutdown();
        }
        this.managers.clear();
        this.durables.clear();
        this.distributor.updated();
        this.clearResources();
    }

    public void shutdownForced() {
        if (!this.closed.commit(false, true)) {
            return;
        }
        this.clearResources();
    }

    SubscriptionManager createSubscriptionManager(SubscriptionContext subscriptionContext, byte relayType, String peerName) throws JMSException {
        if (relayType == 10) {
            return SubscriptionUtil.addDurableSubscription(subscriptionContext, this, peerName, peerName, null, false, true);
        }
        return SubscriptionUtil.addSubscription(subscriptionContext, this, null, false, true);
    }

    synchronized SubscriptionManager addSubscriber(SubscriptionContext subscriptionContext, long id, String selector, boolean noLocal, boolean cluster) throws JMSException {
        NonDurableTopicSubscriptionManager manager = new NonDurableTopicSubscriptionManager(subscriptionContext, id, this, selector, noLocal, cluster);
        this.managers.put(new Long(id), manager);
        this.distributor.updated();
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6052_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6052_LEVEL, JeusMessage_JMS5._6052, new Object[]{this, manager});
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSubscriber(long id) {
        TopicManager topicManager = this;
        synchronized (topicManager) {
            this.managers.remove(new Long(id));
            this.durables.remove(new Long(id));
            this.distributor.updated();
        }
        SubscriptionUtil.removeSubscription(id);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6053_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6053_LEVEL, JeusMessage_JMS5._6053, new Object[]{new Long(id), this});
        }
    }

    synchronized void addDurableSubscriber(SubscriptionManager manager) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._6054_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._6054_LEVEL, JeusMessage_JMS5._6054, new Object[]{this, manager});
        }
        this.durables.put(new Long(manager.getId()), manager);
        this.managers.put(new Long(manager.getId()), manager);
        this.distributor.updated();
        manager.setMaxPendingLimit(this.destination.getMaxPendingLimit());
        manager.setResumeDispatchFactor(this.destination.getResumeDispatchFactor());
    }

    public List getJMSConsumers() {
        ArrayList<AbstractConsumer> v = new ArrayList<AbstractConsumer>();
        for (SubscriptionManager manager : this.getSubscriptionManagers()) {
            AbstractConsumer consumer = manager.getMessageConsumer();
            if (consumer == null) continue;
            v.add(consumer);
        }
        return v;
    }

    public synchronized int getConsumerCount() {
        return this.managers.size();
    }

    public synchronized List getSubscriptionManagers() {
        return new ArrayList(this.managers.values());
    }

    public void refresh() {
        this.stats.setPendingMessageCount(this.executable.queuedWorks());
    }

    public void checkUpperLayer() {
        String localName = this.destination.getLocalName();
        int index = localName.lastIndexOf(".");
        if (index > 0) {
            this.upper = DestinationUtil.findLocalTopicManager(localName.substring(0, index));
        }
    }

    public long takeover(MessageHandler handler, JMSClusterEntry activeBrokerEntry) throws Exception {
        long takeovered = 0L;
        for (Takeoverable takeoverable : this.durables.values()) {
            takeovered += takeoverable.takeover(handler, activeBrokerEntry);
        }
        return takeovered;
    }

    public String toString() {
        return super.toString() + ", managers : " + this.managers.size() + ", limit : " + this.consumerLimit;
    }
}

