/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.mbean;

import javax.jms.JMSException;
import javax.management.InstanceAlreadyExistsException;
import jeus.jms.client.facility.factory.JeusConnectionFactory;
import jeus.jms.common.JMSServiceChannelAddress;
import jeus.jms.server.config.ConnectionFactoryUtil;
import jeus.jms.server.manager.AdministeredObjectBinder;
import jeus.jms.server.manager.ClusterManager;
import jeus.jms.server.manager.ConnectionManager;
import jeus.jms.server.mbean.JMSConnectionFactoryResourceMBean;
import jeus.jms.server.mbean.JMSResource;
import jeus.management.j2ee.J2EEManagedObject;
import jeus.management.j2ee.J2EEResource;

public class JMSConnectionFactoryResource
extends J2EEResource
implements JMSConnectionFactoryResourceMBean {
    private JeusConnectionFactory factory;
    private J2EEManagedObject parent;
    private String factoryName;
    private String exportName;
    private String policyType;
    private boolean cluster;

    public static JMSConnectionFactoryResource createMBean(String mBeanName, JMSResource parent, JeusConnectionFactory target, String exportName) throws InstanceAlreadyExistsException {
        JMSConnectionFactoryResource resource = new JMSConnectionFactoryResource((J2EEManagedObject)parent, target, exportName);
        resource.createMBean(mBeanName, "JeusService", parent.getObjectName(), JMSConnectionFactoryResourceMBean.parentKeyMap, "JMSConnectionFactoryResource");
        return resource;
    }

    public JMSConnectionFactoryResource(J2EEManagedObject parent, JeusConnectionFactory factory, String exportName) {
        this.parent = parent;
        this.factory = factory;
        this.exportName = exportName;
        this.factoryName = factory.getFactoryName();
        this.cluster = factory.isClusterBinding();
        this.policyType = factory.getBrokerSelectionPolicyType();
    }

    public String getBrokerSelectionPolicyType() {
        return this.policyType;
    }

    public boolean isCluster() {
        return this.factory.isClusterBinding();
    }

    public JMSServiceChannelAddress[] getAddresses() {
        return ClusterManager.getClueteredPeersAddresses().toArray(new JMSServiceChannelAddress[0]);
    }

    protected String initPermissionName() {
        return this.parent.getPermissionName() + ".factory." + this.factoryName;
    }

    public void start() throws JMSException {
        try {
            super.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            ConnectionFactoryUtil.destroyConnectionFactory(this.factoryName);
            throw new JMSException("failed to start connection factory");
        }
    }

    public void stop() {
        try {
            super.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void preStart() throws JMSException {
        if (this.cluster) {
            AdministeredObjectBinder.rebind(this.exportName, this.factory, ClusterManager.getClueteredPeersAddresses());
        } else {
            AdministeredObjectBinder.rebind(this.exportName, this.factory);
        }
    }

    protected void preStop() {
        AdministeredObjectBinder.unbindGracefully(this.exportName);
        this.unregisterClientID();
    }

    private boolean unregisterClientID() {
        String clientID = this.factory.getClientID();
        if (clientID == null || clientID.equals("")) {
            return false;
        }
        return ConnectionManager.unregisterClientID(clientID);
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    public String getExportName() {
        return this.exportName;
    }

    public String getFactoryType() {
        return ConnectionFactoryUtil.getTypeString(this.factory.getFactoryType());
    }

    public String getClientID() {
        String clientID = this.factory.getClientID();
        if (clientID == null) {
            return "not-set";
        }
        return (this.factory.isFixedClientID() ? "(fixed)" : "(auto)") + clientID;
    }

    public int getMaxSessionThread() {
        return this.factory.getMaxSessionThread();
    }

    public String getDigest() {
        return this.factory.toString();
    }

    public String toString() {
        return this.factory.toString();
    }
}

