/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.mbean;

import java.security.Permission;
import java.util.List;
import javax.jms.JMSException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;
import jeus.jms.server.manager.DurableTopicSubscriptionManager;
import jeus.jms.server.mbean.JMSDurableSubscriberResourceMBean;
import jeus.management.j2ee.J2EEResource;
import jeus.security.resource.ResourcePermission;
import jeus.security.spi.LoginService;
import jeus.security.util.PermissionMaker;

public class JMSDurableSubscriberResource
extends J2EEResource
implements JMSDurableSubscriberResourceMBean {
    public static final String PREFIX = "DS_";
    private ResourcePermission removeMessagePermission;
    private final DurableTopicSubscriptionManager subscription;

    public static JMSDurableSubscriberResource createMBean(String mBeanName, ObjectName parent, DurableTopicSubscriptionManager target) throws InstanceAlreadyExistsException {
        JMSDurableSubscriberResource resource = new JMSDurableSubscriberResource(target, parent);
        resource.createMBean(mBeanName, "JeusService", parent, JMSDurableSubscriberResourceMBean.parentKeyMap, "JMSDurableSubscriberResource");
        return resource;
    }

    public JMSDurableSubscriberResource(DurableTopicSubscriptionManager subscription, ObjectName parent) {
        super(parent);
        this.subscription = subscription;
    }

    protected String initPermissionName() {
        return "jeus.management.jms.durable." + this.myNameString;
    }

    protected void makePermissions() {
        super.makePermissions();
        this.removeMessagePermission = PermissionMaker.makeResourcePermission((String)this.permissionName, (String)"remove_message");
    }

    public String getDurableName() {
        return this.subscription.getDurableName();
    }

    public String getClientID() {
        return this.subscription.getClientID();
    }

    public int getRemainingMessages() {
        return this.subscription.getMessageNumber();
    }

    public String getSelector() {
        return this.subscription.getSelector();
    }

    public List getMessageInfo(String selector) throws JMSException {
        return this.subscription.getMessageInfo(selector);
    }

    public int removeAllMessage() throws JMSException {
        try {
            LoginService.checkPermission((Permission)this.removeMessagePermission);
        }
        catch (Exception e) {
            throw new JMSException("not enough permission to remove message");
        }
        return this.subscription.removeAllMessage();
    }

    public void remove(String messageID) throws JMSException {
        try {
            LoginService.checkPermission((Permission)this.removeMessagePermission);
        }
        catch (Exception e) {
            throw new JMSException("not enough permission to remove message");
        }
        this.subscription.removeMessage(messageID);
    }

    public String getDigest() {
        return this.subscription.getDigest();
    }
}

