/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.mbean;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import jeus.jms.server.comm.JMSServiceChannel;
import jeus.jms.server.mbean.JMSClientEntryInfo;
import jeus.jms.server.mbean.JMSClientResourceMBean;
import jeus.jms.server.mbean.JMSResource;
import jeus.jms.server.mbean.JMSServiceChannelMoMBean;
import jeus.jms.server.mbean.stats.JMSClientStats;
import jeus.jms.server.util.JaxbUtil;
import jeus.management.JMXUtility;
import jeus.management.j2ee.J2EEResource;
import jeus.util.logging.Journal;
import jeus.xml.binding.jeusDD.ServiceConfig;

public class JMSServiceChannelMo
extends J2EEResource
implements JMSServiceChannelMoMBean {
    private final ServiceConfig config;
    private final JMSServiceChannel target;
    private final JMSResource parent;
    private int keepAliveTime;
    private int readTimeout;
    private int readBufferSize;
    private int writeBufferSize;
    private int clientLimit;
    private boolean checkSecurity;
    private Vector clientResourceList;

    public static JMSServiceChannelMo createMBean(String mBeanName, JMSResource resource, JMSServiceChannel target, ServiceConfig config) throws InstanceAlreadyExistsException {
        JMSServiceChannelMo mbean = new JMSServiceChannelMo(resource, target, config);
        mbean.createMBean(mBeanName, "JeusService", resource.getObjectName(), JMSServiceChannelMoMBean.parentKeyMap, "JMSServiceChannel");
        return mbean;
    }

    public JMSServiceChannelMo(JMSResource parent, JMSServiceChannel target, ServiceConfig config) {
        super(parent.getObjectName());
        this.parent = parent;
        this.target = target;
        this.config = config;
        this.initialize();
    }

    private void initialize() {
        this.readBufferSize = JaxbUtil.getWithDefault(this.config.getReadBufferSize(), this.config.getDefaultReadBufferSize());
        this.writeBufferSize = JaxbUtil.getWithDefault(this.config.getWriteBufferSize(), this.config.getDefaultWriteBufferSize());
        this.checkSecurity = JaxbUtil.getWithDefault(this.config.isCheckSecurity(), this.config.getDefaultCheckSecurity());
        this.keepAliveTime = JaxbUtil.getWithDefault(this.config.getClientKeepaliveTimeout(), this.config.getDefaultClientKeepaliveTimeout());
        this.readTimeout = JaxbUtil.getWithDefault(this.config.getConnectionTimeout(), this.config.getDefaultConnectionTimeout());
        this.clientLimit = JaxbUtil.getWithDefault(this.config.getClientLimit(), this.config.getDefaultClientLimit());
        this.clientResourceList = new Vector(30);
    }

    protected String initPermissionName() {
        return this.parent.getPermissionName() + "." + this.config.getName();
    }

    public void addChild(ObjectName pChild) {
        String lType = JMXUtility.getJeusType((ObjectName)pChild);
        if (lType.equals("JMSClientResource")) {
            this.clientResourceList.add(pChild);
        }
        super.addChild(pChild);
    }

    public void removeChild(ObjectName pChild) {
        String lType = JMXUtility.getJeusType((ObjectName)pChild);
        if (lType.equals("JMSClientResource")) {
            this.clientResourceList.remove(pChild);
        }
        super.removeChild(pChild);
    }

    public String getName() {
        return this.target.toString();
    }

    public String[] getJMSClientResourceNames() {
        return JMXUtility.getAsStringArray((Collection)this.clientResourceList);
    }

    public JMSClientEntryInfo[] getDetailedClientsInfo() {
        try {
            Vector<JMSClientEntryInfo> results = new Vector<JMSClientEntryInfo>(this.clientResourceList.size());
            Enumeration enumeration = this.clientResourceList.elements();
            while (enumeration.hasMoreElements()) {
                JMSClientResourceMBean clientResource = (JMSClientResourceMBean)JMXUtility.getProxy((MBeanServerConnection)this.getRegisteredMBeanServer(), (ObjectName)((ObjectName)enumeration.nextElement()), JMSClientResourceMBean.class, (boolean)false);
                String entryName = clientResource.getName();
                String hostAddress = clientResource.getHostName();
                int port = clientResource.getPort();
                long startTime = ((JMSClientStats)clientResource.getstats()).getConnectionCount().getStartTime();
                results.add(new JMSClientEntryInfo(entryName, hostAddress, port, startTime));
            }
            return results.toArray(new JMSClientEntryInfo[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new JMSClientEntryInfo[0];
        }
    }

    public void addJMSConnectionStats(Stats stats) {
        this.parent.addJMSConnectionStats(stats);
    }

    public void removeJMSConnectionStats(Stats stats) {
        this.parent.removeJMSConnectionStats(stats);
    }

    public JMSServiceChannel getServiceChannel() {
        return this.target;
    }

    public Journal getAccessLogger() {
        return this.parent.getAccessLogger();
    }

    public int getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(int keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean isCheckSecurity() {
        return this.checkSecurity;
    }

    public void setCheckSecurity(boolean checkSecurity) {
        this.checkSecurity = checkSecurity;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }

    public int getClientLimit() {
        return this.clientLimit;
    }

    public void setClientLimit(int clientLimit) {
        this.clientLimit = clientLimit;
    }
}

