/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.message;

import java.util.Map;
import java.util.Random;
import jeus.jms.server.manager.AbstractSubscriptionManager;
import jeus.jms.server.message.ServerMessage;

public interface MessageDistributor {
    public boolean distribute(ServerMessage var1);

    public void updated();

    public static class Fixed
    implements InternalDistributor {
        protected int lastIndex;

        public void setIndex(int index) {
            this.lastIndex = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean distribute(AbstractSubscriptionManager[] iteration, ServerMessage message) {
            try {
                this.lastIndex = this.lastIndex >= iteration.length ? 0 : this.lastIndex;
                boolean bl = iteration[this.lastIndex].enqueueMessage(message);
                return bl;
            }
            finally {
                ++this.lastIndex;
            }
        }
    }

    public static class Iterative
    implements InternalDistributor {
        protected int lastIndex;

        public void setIndex(int index) {
            this.lastIndex = index;
        }

        public boolean distribute(AbstractSubscriptionManager[] iteration, ServerMessage message) {
            this.lastIndex = this.lastIndex >= iteration.length ? 0 : this.lastIndex;
            return this.iterate(iteration, this.lastIndex, iteration.length, message) || this.iterate(iteration, 0, this.lastIndex, message);
        }

        private boolean iterate(AbstractSubscriptionManager[] iteration, int from, int to, ServerMessage message) {
            for (int index = from; index < to; ++index) {
                if (!iteration[index].enqueueMessage(message)) continue;
                this.lastIndex = index + 1;
                return true;
            }
            return false;
        }
    }

    public static class RandomQueueDistributor
    extends SimpleQueueDistributor {
        private Random random = new Random(System.currentTimeMillis());

        public RandomQueueDistributor(Map managers, boolean iterative) {
            super(managers, iterative);
        }

        public boolean distribute(ServerMessage message) {
            this.distributor.setIndex(this.random.nextInt(this.iteration.length));
            return super.distribute(this.iteration, message);
        }
    }

    public static class SimpleQueueDistributor
    extends AbstractDistributor
    implements InternalDistributor {
        protected InternalDistributor distributor;

        public SimpleQueueDistributor(Map managers, boolean iterative) {
            super(managers);
            this.distributor = iterative ? new Iterative() : new Fixed();
        }

        public boolean distribute(ServerMessage message) {
            return this.distribute(this.iteration, message);
        }

        public boolean distribute(AbstractSubscriptionManager[] iteration, ServerMessage message) {
            return this.distributor.distribute(iteration, message);
        }

        public void setIndex(int index) {
            this.distributor.setIndex(index);
        }
    }

    public static class SimpleTopicDistributor
    extends AbstractDistributor {
        public SimpleTopicDistributor(Map managers) {
            super(managers);
        }

        public boolean distribute(ServerMessage message) {
            AbstractSubscriptionManager[] iteration = this.iteration;
            for (int i = 0; i < iteration.length; ++i) {
                iteration[i].enqueueMessage(message);
            }
            return true;
        }
    }

    public static abstract class AbstractDistributor
    implements MessageDistributor {
        protected Map managers;
        protected volatile AbstractSubscriptionManager[] iteration;

        public AbstractDistributor(Map managers) {
            this.managers = managers;
            this.iteration = managers.values().toArray(new AbstractSubscriptionManager[0]);
        }

        public void updated() {
            this.iteration = this.managers.values().toArray(new AbstractSubscriptionManager[0]);
        }
    }

    public static interface InternalDistributor {
        public void setIndex(int var1);

        public boolean distribute(AbstractSubscriptionManager[] var1, ServerMessage var2);
    }
}

