/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.message;

import java.io.File;
import java.io.IOException;
import javax.jms.MessageFormatException;
import jeus.jms.common.JMSEnvironmentValues;
import jeus.jms.common.JMSProperties;
import jeus.jms.common.message.ClientMessage;
import jeus.jms.common.message.FileMessageImpl;
import jeus.jms.common.message.IntermediateSendMessage;
import jeus.jms.common.message.MessageEvent;
import jeus.jms.common.message.MessageEventListener;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.message.MetaHeader;
import jeus.jms.common.message.UserMessage;
import jeus.jms.common.util.BufferInputStream;
import jeus.jms.common.util.MemoryBufferInputStream;
import jeus.jms.server.manager.DestinationManager;
import jeus.jms.server.manager.Scheduler;
import jeus.jms.server.manager.SubscriptionManager;
import jeus.jms.server.message.MessageEventTask;
import jeus.jms.server.message.MessageMonitor;
import jeus.jms.server.message.StoredPacketHandler;
import jeus.jms.server.persistence.MessageArchive;
import jeus.jms.server.persistence.StorageCursor;
import jeus.nio.ByteBufferWrapper;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class ServerMessage
extends UserMessage {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    private transient MessageStatus status;
    private transient StoredPacketHandler handler;
    private transient long id = -1L;
    private transient MessageMonitor destination;
    private transient MessageEventTask expiration;
    private transient MessageEventListener subscription;
    private transient MessageArchive messageArchive;
    private transient boolean storageRecovered;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerMessage(MetaHeader metaHeader, ByteBufferWrapper packet) throws IOException {
        super(metaHeader);
        packet.mark();
        try {
            MemoryBufferInputStream in = new MemoryBufferInputStream(packet);
            this.readHeader(in);
            in.close();
        }
        finally {
            packet.reset();
        }
        this.handler = new StoredPacketHandler(packet);
        this.status = new MessageStatus(false);
    }

    public ServerMessage(ClientMessage message) {
        super(message.getMetaHeader());
        this.msgHeader = message.getHeader();
        this.messageID = message.getMessageID();
        this.properties = message.getProperties();
        this.handler = new StoredPacketHandler(message);
        this.status = new MessageStatus(true);
    }

    public ServerMessage(MetaHeader metaHeader, StorageCursor cursor) {
        super(metaHeader, true);
        this.handler = new StoredPacketHandler(cursor);
        this.status = new MessageStatus(false);
        this.storageRecovered = true;
    }

    private ServerMessage(MetaHeader metaHeader) {
        super(metaHeader);
    }

    public ServerMessage getShallowCopy() {
        MetaHeader hdrClone = this.metaHeader.getClone();
        ServerMessage msgClone = new ServerMessage(hdrClone);
        msgClone.messageID = this.messageID.getClone();
        msgClone.msgHeader = this.msgHeader;
        msgClone.properties = this.properties;
        msgClone.handler = this.handler;
        msgClone.status = this.status;
        msgClone.destination = this.destination;
        msgClone.expiration = this.expiration;
        msgClone.id = this.id;
        msgClone.redeliveryLimit = this.redeliveryLimit;
        msgClone.setProducerID(-1);
        return msgClone;
    }

    public void parseJMSHeader() throws MessageFormatException {
        try {
            BufferInputStream in = this.handler.getContentFromReferenceAsInputStream();
            this.readHeader(in);
        }
        catch (Exception e) {
            throw new MessageFormatException(e.getMessage());
        }
    }

    public void messageEvent(byte event) {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7221_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7221_LEVEL, JeusMessage_JMS5._7221, new Object[]{MessageEvent.getEventType(event), this});
        }
        switch (event) {
            case 0: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                this.destination.messageEvent(this, event);
                break;
            }
            case 8: {
                ServerMessage message = this.getShallowCopy();
                Scheduler.scheduleMessageEventTo(message, (byte)1, message.getScheduledTime());
                break;
            }
            case 1: {
                this.msgHeader.setScheduled(false);
                this.destination.messageEvent(this, event);
                break;
            }
            case 15: {
                this.status.setExpired(true);
                this.destination.messageEvent(this, (byte)20);
                break;
            }
            case 4: 
            case 5: 
            case 20: {
                if (this.subscription == null) break;
                this.subscription.messageEvent(this, event);
            }
        }
    }

    public void clearResource() {
        block7: {
            this.cancelExpirationTask();
            if (JMSProperties.REMOVE_FILE_AFTER_ON_MESSAGE && this.metaHeader.getMessageType() == 70) {
                try {
                    ClientMessage msg = this.getClientMessageCopy();
                    if (msg instanceof FileMessageImpl) {
                        String fileName = ((FileMessageImpl)msg).getTargetFileName();
                        File file = new File(JMSEnvironmentValues.getServerFileMsgDir(), fileName);
                        if (file.exists()) {
                            file.delete();
                            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7222_LEVEL)) {
                                LogUtils.log(logger, JeusMessage_JMS5._7222_LEVEL, JeusMessage_JMS5._7222, msg);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (!LogUtils.isLoggable(logger, JeusMessage_JMS5._7223_LEVEL)) break block7;
                    LogUtils.log(logger, JeusMessage_JMS5._7223_LEVEL, JeusMessage_JMS5._7223, this, (Throwable)e);
                }
            }
        }
        if (this.destination != null) {
            this.destination.changeMemoryUsage(-this.handler.occupied());
        }
        this.handler.clear();
    }

    public void recoverContents() {
        this.setJMSRedelivered(true);
    }

    public String toString() {
        return this.status + ":" + (this.id == -1L ? "Mx" : String.valueOf(this.id)) + super.toString();
    }

    public String dumpString() {
        StringBuffer buf = new StringBuffer(super.dumpString());
        buf.append(" + ServerMessage[status=");
        buf.append(this.status);
        buf.append(",handle=");
        buf.append(this.handler);
        buf.append("]");
        return buf.toString();
    }

    public synchronized IntermediateSendMessage getWritableMessage(boolean direct) throws IOException {
        ByteBufferWrapper buffer = this.handler.getContentFromStorage(direct);
        return new IntermediateSendMessage(buffer, this);
    }

    public boolean isDistributed() {
        return this.status.isDistributed();
    }

    public void startDistribute() {
        this.status.setDistributed(false);
    }

    public void endDistribute() {
        this.status.setDistributed(true);
    }

    public void incrementReference() {
        this.status.increaseReferenceCount();
    }

    public boolean decreaseReference() {
        return this.status.decreaseReferenceCount() == 0 && this.status.isDistributed();
    }

    public boolean checkReference() {
        return this.status.getReferenceCount() == 0 && this.status.isDistributed();
    }

    public long getQueuedTime() {
        return this.status.getQueuedTime();
    }

    public void setQueuedTime(long queuedTime) {
        this.status.setQueuedTime(queuedTime);
        if (this.isExpire()) {
            this.expiration = Scheduler.scheduleMessageEventTo(this, (byte)15, this.getExpiration());
        }
    }

    public boolean isLocalMessage() {
        return this.status.isLocal();
    }

    public boolean isExpired() {
        return this.status.isExpired();
    }

    public ByteBufferWrapper getContent() throws IOException {
        return this.handler.getContentFromReference();
    }

    public ClientMessage getClientMessageCopy() throws IOException {
        return this.handler.getContentFromStorageAsMessage(this.metaHeader);
    }

    public int occupied() {
        return this.handler.occupied();
    }

    public void overwriteClientMessageID(MessageID messageID) {
        this.handler.overwriteClientMessageID(messageID);
    }

    public void stored(StorageCursor cursor) {
        this.handler.setStorageCursor(cursor);
        if (cursor.isPersistent() && this.destination.exceedLowMark()) {
            this.handler.softenContent(this.destination.exceedHighMark());
        }
        this.setPersisted(cursor.isPersistent());
        cursor.clear();
    }

    public void setDestinationEventListener(DestinationManager destination) {
        this.destination = destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelExpirationTask() {
        try {
            boolean bl = this.expiration != null && this.expiration.cancel();
            return bl;
        }
        finally {
            this.expiration = null;
        }
    }

    public boolean isStorageRecovered() {
        return this.storageRecovered;
    }

    public void setSubscriptionEventListener(SubscriptionManager subscription) {
        this.subscription = subscription;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setMessageArchive(MessageArchive messageArchive) {
        this.messageArchive = messageArchive;
    }

    public MessageArchive getMessageArchive() {
        return this.messageArchive;
    }

    private class MessageStatus {
        private final boolean local;
        private long queuedTime;
        private boolean distributed;
        private boolean expired;
        private int referenceCount;

        public MessageStatus(boolean local) {
            this.local = local;
        }

        private boolean isLocal() {
            return this.local;
        }

        private synchronized int getReferenceCount() {
            return this.referenceCount;
        }

        private synchronized int increaseReferenceCount() {
            return ++this.referenceCount;
        }

        private synchronized int decreaseReferenceCount() {
            return --this.referenceCount;
        }

        private synchronized boolean isExpired() {
            return this.expired;
        }

        private synchronized void setExpired(boolean expired) {
            this.expired = expired;
        }

        private synchronized boolean isDistributed() {
            return this.distributed;
        }

        private synchronized void setDistributed(boolean distributed) {
            this.distributed = distributed;
        }

        private long getQueuedTime() {
            return this.queuedTime;
        }

        private void setQueuedTime(long queuedTime) {
            this.queuedTime = queuedTime;
        }

        public String toString() {
            return (this.isLocal() ? "L" : "R") + this.getReferenceCount();
        }
    }
}

