/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database;

import jeus.jms.server.persistence.LifecycleLogger;
import jeus.jms.server.persistence.ReliabilityLevel;
import jeus.jms.server.persistence.database.DatabaseStorage;

public class DatabaseLifecycleLogger
extends LifecycleLogger {
    private DatabaseStorage storage;

    public DatabaseLifecycleLogger(ReliabilityLevel level, DatabaseStorage storage) {
        super(level);
        this.storage = storage;
    }

    public boolean enqueued(long messageId) {
        return this.storage.changeLifeCycle(messageId, (byte)2);
    }

    public boolean dispatched(long messageId) {
        return this.level != ReliabilityLevel.PRODUCE && this.storage.changeLifeCycle(messageId, (byte)4);
    }

    public boolean dispatched(long messageId, long durableSubscriberId) {
        return this.level != ReliabilityLevel.PRODUCE && this.storage.changeLifeCycle(messageId, durableSubscriberId, (byte)4);
    }

    public boolean distributed(long messageId) {
        return this.storage.changeLifeCycle(messageId, (byte)8);
    }

    public boolean completed(long messageId) {
        return this.level == ReliabilityLevel.COMPLETE && this.storage.changeLifeCycle(messageId, (byte)16);
    }

    public boolean completed(long messageId, long durableSubscriberId) {
        return this.level == ReliabilityLevel.COMPLETE && this.storage.changeLifeCycle(messageId, durableSubscriberId, (byte)16);
    }
}

