/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import jeus.jms.common.util.JMSXid;
import jeus.jms.server.persistence.GlobalTransactionContext;
import jeus.jms.server.persistence.XALogger;
import jeus.jms.server.persistence.XARecoveryListener;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.command.DeleteXACommand;
import jeus.jms.server.persistence.database.command.PreparedXACommand;
import jeus.jms.server.persistence.database.command.PreparingXACommand;
import jeus.jms.server.persistence.database.command.RecoverXACommand;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class DatabaseXALogger
implements XALogger {
    private JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms.server.persistence");
    private DatabaseStorage storage;
    private Set inDoubtXids = new HashSet();

    public DatabaseXALogger(DatabaseStorage storage) {
        this.storage = storage;
    }

    public boolean start(JMSXid xid, boolean remote) {
        return true;
    }

    public boolean end(JMSXid xid, boolean remote) {
        return true;
    }

    public boolean preparing(JMSXid xid, boolean remote) {
        if (!remote) {
            return true;
        }
        PreparingXACommand command = new PreparingXACommand(this.storage, xid);
        return this.storage.executeWithoutException(command);
    }

    public boolean prepared(JMSXid xid, boolean remote) {
        if (!remote) {
            return true;
        }
        PreparedXACommand command = new PreparedXACommand(this.storage, xid);
        return this.storage.executeWithoutException(command);
    }

    public boolean committed(JMSXid xid, boolean prepared, boolean remote) {
        return !prepared || !remote || this.completed(xid, true);
    }

    public boolean rolledback(JMSXid xid, boolean prepared, boolean remote) {
        return !prepared || !remote || this.completed(xid, true);
    }

    public boolean completed(JMSXid xid, boolean remote) {
        if (!remote) {
            return true;
        }
        DeleteXACommand command = new DeleteXACommand(this.storage, xid);
        return this.storage.executeWithoutException(command);
    }

    public void recover(XARecoveryListener listener) {
        RecoverXACommand command = new RecoverXACommand(this.storage, listener, Collections.unmodifiableSet(this.inDoubtXids));
        this.storage.executeWithoutException(command);
    }

    public void init() throws Exception {
        this.loadInDoubtXids();
    }

    private void loadInDoubtXids() throws Exception {
        block4: {
            GlobalTransactionContext context = this.storage.createGlobalTransactionContext(null);
            try {
                Xid[] xids = this.storage.getDatabasePlatform().recover(context);
                if (xids != null && xids.length > 0) {
                    for (int i = 0; i < xids.length; ++i) {
                        JMSXid xid = new JMSXid(xids[i]);
                        this.inDoubtXids.add(xid);
                    }
                }
            }
            catch (XAException xae) {
                this.storage.getDatabasePlatform().handleXAException(xae);
                if (!LogUtils.isLoggable(this.logger, JeusMessage_JMS5._5261_LEVEL)) break block4;
                LogUtils.log(this.logger, JeusMessage_JMS5._5261_LEVEL, JeusMessage_JMS5._5261, xae);
            }
        }
    }

    public void prepareShutdown() {
    }

    public void shutdown() {
    }

    public void shutdownAll() {
    }

    public void start() throws IOException {
    }
}

