/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import jeus.jms.server.persistence.database.DatabasePlatform;
import jeus.jms.server.persistence.database.LongString;

public class DerbyPlatform
extends DatabasePlatform {
    public static final String EMBEDDED_DS = "org.apache.derby.jdbc.EmbeddedDataSource";
    public static final String EMBEDDED_CPDS = "org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource";
    public static final String EMBEDDED_XADS = "org.apache.derby.jdbc.EmbeddedXADataSource";
    private static Class embeddedDataSourceClass;
    private static Class embeddedConnectionPoolDataSourceClass;
    private static Class embeddedXADataSourceClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkTable(String name, Connection con) throws SQLException {
        Statement stmt = con.createStatement();
        boolean exists = false;
        try {
            ResultSet rs = stmt.executeQuery("SELECT TABLENAME FROM SYS.SYSTABLES WHERE TABLENAME='" + name + "'");
            exists = rs.next();
        }
        finally {
            stmt.close();
        }
        return exists;
    }

    public static DataSource getEmbeddedDataSource(String databaseName) {
        try {
            if (embeddedDataSourceClass == null) {
                embeddedDataSourceClass = DerbyPlatform.class.getClassLoader().loadClass(EMBEDDED_XADS);
            }
            DataSource ds = (DataSource)embeddedDataSourceClass.newInstance();
            embeddedDataSourceClass.getMethod("setDatabaseName", String.class).invoke((Object)ds, databaseName);
            embeddedDataSourceClass.getMethod("setCreateDatabase", String.class).invoke((Object)ds, "create");
            return ds;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException("Could not load a embedded Derby database instance. Please check if derby.jar exist in the classpath. Thrown: " + ex);
        }
    }

    protected Map buildTypeNames() {
        HashMap<Class, String> fieldTypeMapping = new HashMap<Class, String>();
        fieldTypeMapping.put(Boolean.class, "SMALLINT");
        fieldTypeMapping.put(Integer.class, "INTEGER");
        fieldTypeMapping.put(Long.class, "BIGINT");
        fieldTypeMapping.put(Float.class, "FLOAT");
        fieldTypeMapping.put(Double.class, "FLOAT");
        fieldTypeMapping.put(Short.class, "SMALLINT");
        fieldTypeMapping.put(Byte.class, "SMALLINT");
        fieldTypeMapping.put(BigInteger.class, "BIGINT");
        fieldTypeMapping.put(BigDecimal.class, "DECIMAL");
        fieldTypeMapping.put(Number.class, "DECIMAL");
        fieldTypeMapping.put(LongString.class, "VARCHAR(" + this.getMaxStringLength() + ")");
        fieldTypeMapping.put(String.class, "VARCHAR(255)");
        fieldTypeMapping.put(Character.class, "CHAR(1)");
        fieldTypeMapping.put(Byte[].class, "BLOB");
        fieldTypeMapping.put(Character[].class, "CLOB");
        fieldTypeMapping.put(byte[].class, "BLOB");
        fieldTypeMapping.put(char[].class, "CLOB");
        fieldTypeMapping.put(Blob.class, "BLOB");
        fieldTypeMapping.put(Clob.class, "CLOB");
        fieldTypeMapping.put(Date.class, "DATE");
        fieldTypeMapping.put(Time.class, "TIME");
        fieldTypeMapping.put(Timestamp.class, "TIMESTAMP");
        return fieldTypeMapping;
    }

    protected Map buildSqlTypes() {
        HashMap<Class<Time>, Integer> sqlTypeMapping = new HashMap<Class<Time>, Integer>();
        sqlTypeMapping.put(Boolean.class, new Integer(5));
        sqlTypeMapping.put(Integer.class, new Integer(4));
        sqlTypeMapping.put(Long.class, new Integer(-5));
        sqlTypeMapping.put(Float.class, new Integer(6));
        sqlTypeMapping.put(Double.class, new Integer(8));
        sqlTypeMapping.put(Short.class, new Integer(5));
        sqlTypeMapping.put(Byte.class, new Integer(5));
        sqlTypeMapping.put(BigInteger.class, new Integer(-5));
        sqlTypeMapping.put(BigDecimal.class, new Integer(-5));
        sqlTypeMapping.put(LongString.class, new Integer(12));
        sqlTypeMapping.put(String.class, new Integer(12));
        sqlTypeMapping.put(Character.class, new Integer(1));
        sqlTypeMapping.put(Byte[].class, new Integer(2004));
        sqlTypeMapping.put(Character[].class, new Integer(2005));
        sqlTypeMapping.put(byte[].class, new Integer(2004));
        sqlTypeMapping.put(char[].class, new Integer(2005));
        sqlTypeMapping.put(Blob.class, new Integer(2004));
        sqlTypeMapping.put(Clob.class, new Integer(2005));
        sqlTypeMapping.put(Date.class, new Integer(91));
        sqlTypeMapping.put(Timestamp.class, new Integer(93));
        sqlTypeMapping.put(Time.class, new Integer(92));
        return sqlTypeMapping;
    }

    public void setEmptyBlob(PreparedStatement stmt, int index) throws Exception {
        stmt.setBytes(index, new byte[]{0});
    }

    public void writeBlobData(Blob blob, byte[] data) throws Exception {
        blob.setBytes(1L, data);
    }

    public int getMaxStringLength() {
        return 32627;
    }
}

