/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.jms.common.util.JMSXid;
import jeus.jms.server.persistence.GlobalTransactionContext;
import jeus.jms.server.persistence.Storage;
import jeus.jms.server.persistence.database.DatabasePlatform;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.DatabaseTransactionContext;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class GlobalDatabaseTransactionContext
implements GlobalTransactionContext,
DatabaseTransactionContext {
    private static JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    private static HashMap xidMap = new HashMap();
    private Connection connection;
    private XAConnection xaConnection;
    private XAResource xaResource;
    private DataSource dataSource;
    private DatabasePlatform platform;
    private DatabaseStorage storage;

    public GlobalDatabaseTransactionContext(DatabaseStorage storage, DatabasePlatform platform, DataSource dataSource) throws SQLException {
        this.storage = storage;
        this.platform = platform;
        this.dataSource = dataSource;
    }

    public synchronized Connection getConnection() throws SQLException {
        try {
            this.checkXAResource();
        }
        catch (XAException e) {
            throw new SQLException(e.getMessage());
        }
        this.connection.setAutoCommit(false);
        return this.connection;
    }

    public synchronized boolean releaseResource() {
        try {
            this.platform.releaseXAConnection(this.dataSource, this.xaConnection, this.connection);
            this.xaResource = null;
            this.xaConnection = null;
            this.connection = null;
        }
        catch (SQLException sqlEx) {
            sqlEx.printStackTrace();
            return false;
        }
        return true;
    }

    private void checkXAResource() throws XAException {
        try {
            if (this.xaResource == null) {
                if (this.xaConnection == null) {
                    this.xaConnection = this.platform.getXAConnection(this.dataSource);
                }
                this.connection = this.xaConnection.getConnection();
                if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5181_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS5._5181_LEVEL, JeusMessage_JMS5._5181, this.connection.isClosed());
                }
                this.xaResource = this.xaConnection.getXAResource();
            }
        }
        catch (SQLException e) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5182_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5182_LEVEL, JeusMessage_JMS5._5182, e.getMessage(), (Throwable)e);
            }
            this.releaseResource();
            XAException xaException = new XAException(e.getMessage());
            xaException.errorCode = -7;
            throw xaException;
        }
    }

    public int getTransactionTimeout() throws XAException {
        this.checkXAResource();
        return this.xaResource.getTransactionTimeout();
    }

    public boolean setTransactionTimeout(int i) throws XAException {
        this.checkXAResource();
        return this.platform.supportsSetTransactionTimeout() && this.xaResource.setTransactionTimeout(i);
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        this.checkXAResource();
        return this.xaResource.isSameRM(xaResource);
    }

    public Xid[] recover(int i) throws XAException {
        this.checkXAResource();
        return this.xaResource.recover(i);
    }

    public int prepare(Xid xid) throws XAException {
        Xid validXid = this.getXid(xid);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5183_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5183_LEVEL, JeusMessage_JMS5._5183, validXid.toString());
        }
        this.checkXAResource();
        int result = this.xaResource.prepare(validXid);
        if (result == 3) {
            this.removeXid(xid);
        }
        return result;
    }

    public void forget(Xid xid) throws XAException {
        Xid validXid = this.getXid(xid);
        this.checkXAResource();
        this.xaResource.forget(validXid);
        this.removeXid(xid);
    }

    public void rollback(Xid xid) throws XAException {
        Xid validXid = this.getXid(xid);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5184_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5184_LEVEL, JeusMessage_JMS5._5184, validXid.toString());
        }
        this.checkXAResource();
        this.xaResource.rollback(validXid);
        this.removeXid(xid);
    }

    public void end(Xid xid, int i) throws XAException {
        Xid validXid = this.getXid(xid);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5185_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5185_LEVEL, JeusMessage_JMS5._5185, validXid.toString());
        }
        this.checkXAResource();
        this.xaResource.end(validXid, i);
    }

    public void start(Xid xid, int i) throws XAException {
        Xid validXid = this.getXid(xid);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5186_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5186_LEVEL, JeusMessage_JMS5._5186, validXid.toString());
        }
        this.checkXAResource();
        this.xaResource.start(validXid, i);
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        Xid validXid = this.getXid(xid);
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5187_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5187_LEVEL, JeusMessage_JMS5._5187, validXid.toString());
        }
        this.checkXAResource();
        this.xaResource.commit(validXid, onePhase);
        this.removeXid(xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Xid getXid(Xid xid) throws XAException {
        Xid sourceXid;
        if (xid instanceof JMSXid && (sourceXid = ((JMSXid)xid).getSourceXid()) != null) {
            return sourceXid;
        }
        HashMap hashMap = xidMap;
        synchronized (hashMap) {
            if (xidMap.containsKey(xid)) {
                return (Xid)xidMap.get(xid);
            }
            Xid nativeXid = this.platform.createXid(xid);
            xidMap.put(xid, nativeXid);
            return nativeXid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeXid(Xid xid) {
        HashMap hashMap = xidMap;
        synchronized (hashMap) {
            xidMap.remove(xid);
        }
    }

    public Storage getStorage() {
        return this.storage;
    }

    public boolean isXA() {
        return true;
    }

    public void postExecute() throws XAException {
    }

    public void preExecute() throws XAException {
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.releaseResource();
    }
}

