/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import jeus.jms.server.persistence.database.DatabasePlatform;

public class ManagedDatabasePlatform
extends DatabasePlatform {
    private static Method getTypeMethod;
    private static Method getRawXAConnectionMethod;
    private static Method getDelegateDataSourceMethod;
    private static Method closeRawXAConnectionMethod;
    private static boolean resolved;
    private DataSource delegateDataSource;

    public synchronized void init(DataSource dataSource, Connection con) throws Exception {
        if (!resolved) {
            Class<?> c = dataSource.getClass();
            getTypeMethod = c.getMethod("getType", null);
            getRawXAConnectionMethod = c.getMethod("getRawXAConnection", null);
            closeRawXAConnectionMethod = c.getMethod("closeRawXAConnection", XAConnection.class, Boolean.TYPE);
            try {
                getDelegateDataSourceMethod = c.getMethod("getDelegateDataSource", null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            resolved = true;
        }
        if (getDelegateDataSourceMethod != null) {
            try {
                this.delegateDataSource = (DataSource)getDelegateDataSourceMethod.invoke((Object)dataSource, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw new SQLException(e.getMessage());
            }
        }
        super.init(dataSource, con);
    }

    protected boolean supportsXA(DataSource dataSource) {
        try {
            Integer dsType = (Integer)getTypeMethod.invoke((Object)dataSource, null);
            return dsType == 2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Connection getConnection(DataSource dataSource) throws SQLException {
        if (this.delegateDataSource != null) {
            return this.delegateDataSource.getConnection();
        }
        return super.getConnection(dataSource);
    }

    public XAConnection getXAConnection(DataSource dataSource) throws SQLException {
        try {
            return (XAConnection)getRawXAConnectionMethod.invoke((Object)dataSource, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new SQLException(e.getMessage());
        }
    }

    public void releaseXAConnection(DataSource dataSource, XAConnection xaConnection, Connection connection) throws SQLException {
        try {
            if (connection != null) {
                connection.close();
            }
            if (xaConnection != null) {
                closeRawXAConnectionMethod.invoke((Object)dataSource, xaConnection, Boolean.FALSE);
            }
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new SQLException(e.getMessage());
        }
    }
}

