/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.jms.JMSException;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;

public abstract class BlobSQLCommand
extends SimpleSQLCommand {
    public BlobSQLCommand(DatabaseStorage storage) {
        super(storage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        block6: {
            byte[] data = this.preBlob(connection);
            if (data != null) {
                PreparedStatement stmt = connection.prepareStatement(this.getBlobSQL());
                this.prepareBlobStatement(connection, stmt, data);
                ResultSet rs = null;
                try {
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        Blob blob = rs.getBlob(this.getBlobColumnName());
                        this.getDatabasePlatform().writeBlobData(blob, data);
                        break block6;
                    }
                    throw new JMSException("failed to query blob column.");
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    stmt.close();
                }
            }
        }
        this.postBlob(connection);
    }

    public final boolean isAutoCommit() {
        return false;
    }

    protected abstract byte[] preBlob(Connection var1) throws Exception;

    protected abstract void postBlob(Connection var1) throws Exception;

    protected abstract PreparedStatement prepareBlobStatement(Connection var1, PreparedStatement var2, byte[] var3) throws Exception;

    protected abstract String getBlobSQL();

    protected abstract String getBlobColumnName();
}

