/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.util.logging.Level;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLCommand;
import jeus.jms.server.persistence.database.command.SQLCommandBase;

public class CompositeSQLCommand
extends SQLCommandBase {
    private static final boolean NEED_LOGGING = logger.isLoggable(Level.FINEST);
    private SQLCommand[] commands;
    private String name;

    public CompositeSQLCommand(String name, DatabaseStorage storage, SQLCommand[] commands) {
        super(storage);
        this.name = name;
        this.commands = commands;
    }

    public final void execute(Connection connection) throws Exception {
        for (int i = 0; i < this.commands.length; ++i) {
            SQLCommand command = this.commands[i];
            if (command.isSynchronous()) {
                if (NEED_LOGGING) {
                    command.log();
                }
                command.execute(connection);
                continue;
            }
            this.storage.execute(command);
        }
    }

    public String getSQL() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.commands.length; ++i) {
            SQLCommand command = this.commands[i];
            buf.append(command.getSQL());
            if (i >= this.commands.length - 1) continue;
            buf.append(";");
        }
        return buf.toString();
    }

    public boolean isAutoCommit() {
        return false;
    }

    public String getName() {
        return this.name;
    }
}

