/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import jeus.jms.client.JMSServerEntry;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;

public class DeleteDestinationCommand
extends SimpleSQLCommand {
    public static final String COMMAND_NAME = "DELETE_DESTINATION";
    private long id;

    public DeleteDestinationCommand(DatabaseStorage storage, long id) {
        super(storage);
        this.id = id;
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DELETE FROM ").append(this.storage.getDestinationTableName()).append(" WHERE ");
        buffer.append("DT_ID").append("=?");
        return buffer.toString();
    }

    public SQLParameter[] getSQLParameters() {
        return new SQLParameter[]{new SQLParameter("DT_ID", String.valueOf(this.id))};
    }

    public String getName() {
        return COMMAND_NAME;
    }

    public boolean isSynchronous() {
        return JMSServerEntry.RI_COMPATIBLE;
    }

    public boolean isHighPriority() {
        return JMSServerEntry.RI_COMPATIBLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        PreparedStatement stmt = connection.prepareStatement(this.getSQL());
        try {
            stmt.setLong(1, this.id);
            stmt.executeUpdate();
        }
        finally {
            stmt.close();
        }
    }
}

