/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;

public class DeleteDurableMessageCommand
extends SimpleSQLCommand {
    public static final String COMMAND_NAME = "DELETE_DURABLE_MESSAGE";
    private long messageId;
    private long durableSubscriberId;

    public DeleteDurableMessageCommand(DatabaseStorage storage, long messageId, long durableSubscriberId) {
        super(storage);
        this.messageId = messageId;
        this.durableSubscriberId = durableSubscriberId;
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DELETE FROM ").append(this.storage.getDurableMessageTableName()).append(" WHERE ");
        buffer.append("MG_ID").append("=?").append(" AND ").append("DS_ID").append("=?");
        return buffer.toString();
    }

    public SQLParameter[] getSQLParameters() {
        return new SQLParameter[]{new SQLParameter("MG_ID", String.valueOf(this.messageId)), new SQLParameter("DS_ID", String.valueOf(this.durableSubscriberId))};
    }

    public String getName() {
        return COMMAND_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        PreparedStatement stmt = connection.prepareStatement(this.getSQL());
        try {
            stmt.setLong(1, this.messageId);
            stmt.setLong(2, this.durableSubscriberId);
            stmt.executeUpdate();
        }
        finally {
            stmt.close();
        }
    }
}

