/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class DeleteMessageCommand
extends SimpleSQLCommand {
    public static final String COMMAND_NAME = "DELETE_MESSAGE";
    private long id;

    public DeleteMessageCommand(DatabaseStorage storage, long id) {
        super(storage);
        this.id = id;
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DELETE FROM ").append(this.storage.getMessageTableName()).append(" WHERE ");
        buffer.append("MG_ID").append("=?");
        return buffer.toString();
    }

    public SQLParameter[] getSQLParameters() {
        return new SQLParameter[]{new SQLParameter("MG_ID", String.valueOf(this.id))};
    }

    public String getName() {
        return COMMAND_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        PreparedStatement stmt = connection.prepareStatement(this.getSQL());
        try {
            stmt.setLong(1, this.id);
            int rows = stmt.executeUpdate();
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5471_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5471_LEVEL, JeusMessage_JMS5._5471, new Integer(rows));
            }
        }
        finally {
            stmt.close();
        }
    }
}

