/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import jeus.jms.client.JMSServerEntry;
import jeus.jms.common.JMSProperties;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLCommand;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.jms.server.persistence.database.command.CompositeSQLCommand;
import jeus.jms.server.persistence.database.command.LoopSQLCommand;
import jeus.jms.server.persistence.database.command.RangeDeleteMessagesCommand;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class DeleteMessagesCommand
extends LoopSQLCommand {
    public static final String COMMAND_NAME = "DELETE_MESSAGES";
    private long destinationId;

    public DeleteMessagesCommand(DatabaseStorage storage, long destinationId) {
        super(storage);
        this.destinationId = destinationId;
    }

    protected final String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT COUNT(").append("MG_ID").append(") AS ").append("MG_COUNTS").append(", ");
        buffer.append(" MIN(").append("MG_ID").append(") AS ").append("MG_MIN_ID").append(", ");
        buffer.append(" MAX(").append("MG_ID").append(") AS ").append("MG_MAX_ID");
        buffer.append(" FROM ").append(this.storage.getMessageTableName()).append(" WHERE ");
        buffer.append("DT_ID").append("=?");
        return buffer.toString();
    }

    public SQLParameter[] getSQLParameters() {
        return new SQLParameter[]{new SQLParameter("DT_ID", String.valueOf(this.destinationId))};
    }

    public boolean isSynchronous() {
        return JMSServerEntry.RI_COMPATIBLE;
    }

    public boolean isHighPriority() {
        return JMSServerEntry.RI_COMPATIBLE;
    }

    public String getName() {
        return COMMAND_NAME;
    }

    protected SQLCommand getSQLCommand(Connection connection, Object item) throws Exception {
        long[] result = (long[])item;
        long counts = result[0];
        long min = result[1];
        long max = result[2];
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5351_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5351_LEVEL, JeusMessage_JMS5._5351, new Object[]{COMMAND_NAME, new Long(counts)});
        }
        int deleteSize = JMSProperties.DELETE_PARTITION_SIZE;
        long appCounts = counts == 0L ? 0L : max - min + 1L;
        int cmdCounts = (int)appCounts / deleteSize + (appCounts % (long)deleteSize > 0L ? 1 : 0);
        SQLCommand[] commands = new SQLCommand[cmdCounts];
        for (int i = 0; i < cmdCounts; ++i) {
            long from = min + (long)(i * deleteSize);
            long to = i + 1 < cmdCounts ? from + (long)deleteSize - 1L : max;
            commands[i] = new RangeDeleteMessagesCommand(this.storage, this.destinationId, from, to);
        }
        return new CompositeSQLCommand("PARTITIONED_DELETE_MESSAGES", this.storage, commands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator getIterator(Connection connection) throws Exception {
        PreparedStatement stmt = connection.prepareStatement(this.getSQL());
        ResultSet rs = null;
        ArrayList<long[]> results = new ArrayList<long[]>();
        try {
            stmt.setLong(1, this.destinationId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                long counts = rs.getLong("MG_COUNTS");
                long min = rs.getLong("MG_MIN_ID");
                long max = rs.getLong("MG_MAX_ID");
                results.add(new long[]{counts, min, max});
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            stmt.close();
        }
        return results.iterator();
    }
}

