/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import jeus.jms.common.message.MessageID;
import jeus.jms.server.persistence.database.DatabasePlatform;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;

public class GetDurableMessageLifecycleCommand
extends SimpleSQLCommand {
    public static final String COMMAND_NANE = "GET_DURABLE_MESSAGE_LIFECYCLE_COMMAND";
    private long durableSubscriberId;
    private MessageID msgID;
    private byte lifecycle;

    public GetDurableMessageLifecycleCommand(DatabaseStorage storage, long durableSubscriberId, MessageID msgID) {
        super(storage);
        this.durableSubscriberId = durableSubscriberId;
        this.msgID = msgID;
    }

    protected String createSQL() {
        DatabasePlatform platform = this.storage.getDatabasePlatform();
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT ");
        buffer.append("DM.").append("DM_LIFECYCLE");
        buffer.append(" FROM ");
        buffer.append(platform.getTableAlias(this.storage.getMessageTableName(), "MG")).append(", ");
        buffer.append(platform.getTableAlias(this.storage.getDurableMessageTableName(), "DM")).append(" ");
        buffer.append("WHERE ");
        buffer.append("MG.").append("MG_BROKER_ID").append("=? AND ");
        buffer.append("MG.").append("MG_ENTRY_ID").append("=? AND ");
        buffer.append("MG.").append("MG_CONNECTION_ID").append("=? AND ");
        buffer.append("MG.").append("MG_SEQUENCE").append("=? AND ");
        buffer.append("MG.").append("MG_ID").append("=").append("DM.").append("MG_ID").append(" AND ");
        buffer.append("DM.").append("DS_ID").append("=? ");
        return buffer.toString();
    }

    public SQLParameter[] getSQLParameters() {
        return new SQLParameter[]{new SQLParameter("MG.MG_BROKER_ID", String.valueOf(this.msgID.getBrokerID())), new SQLParameter("MG.MG_ENTRY_ID", String.valueOf(this.msgID.getEntryID())), new SQLParameter("MG.MG_CONNECTION_ID", String.valueOf(this.msgID.getConnectionID())), new SQLParameter("MG.MG_SEQUENCE", String.valueOf(this.msgID.getSequenceNumber())), new SQLParameter("DM.DS_ID", String.valueOf(this.durableSubscriberId))};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        PreparedStatement stmt = connection.prepareStatement(this.getSQL());
        try {
            stmt.setShort(1, this.msgID.getBrokerID());
            stmt.setLong(2, this.msgID.getEntryID());
            stmt.setLong(3, this.msgID.getConnectionID());
            stmt.setInt(4, this.msgID.getSequenceNumber());
            stmt.setLong(5, this.durableSubscriberId);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                this.lifecycle = rs.getByte("DM_LIFECYCLE");
            }
            rs.close();
        }
        finally {
            stmt.close();
        }
    }

    public String getName() {
        return COMMAND_NANE;
    }

    public byte getLifecycle() {
        return this.lifecycle;
    }
}

