/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import jeus.jms.common.message.MessageID;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;

public class GetMessageLifecycleCommand
extends SimpleSQLCommand {
    public static final String COMMAND_NANE = "GET_MESSAGE_LIFECYCLE_COMMAND";
    private MessageID msgID;
    private byte lifecycle;

    public GetMessageLifecycleCommand(DatabaseStorage storage, MessageID msgID) {
        super(storage);
        this.msgID = msgID;
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT ").append("MG_LIFECYCLE").append(" FROM ").append(this.storage.getMessageTableName());
        buffer.append(" WHERE ").append("MG_BROKER_ID").append("=? AND ");
        buffer.append("MG_ENTRY_ID").append("=? AND ");
        buffer.append("MG_CONNECTION_ID").append("=? AND ");
        buffer.append("MG_SEQUENCE").append("=?");
        return buffer.toString();
    }

    public SQLParameter[] getSQLParameters() {
        return new SQLParameter[]{new SQLParameter("MG_BROKER_ID", String.valueOf(this.msgID.getBrokerID())), new SQLParameter("MG_ENTRY_ID", String.valueOf(this.msgID.getEntryID())), new SQLParameter("MG_CONNECTION_ID", String.valueOf(this.msgID.getConnectionID())), new SQLParameter("MG_SEQUENCE", String.valueOf(this.msgID.getSequenceNumber()))};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        PreparedStatement stmt = connection.prepareStatement(this.getSQL());
        try {
            stmt.setShort(1, this.msgID.getBrokerID());
            stmt.setLong(2, this.msgID.getEntryID());
            stmt.setLong(3, this.msgID.getConnectionID());
            stmt.setInt(4, this.msgID.getSequenceNumber());
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                this.lifecycle = rs.getByte("MG_LIFECYCLE");
            }
            rs.close();
        }
        finally {
            stmt.close();
        }
    }

    public String getName() {
        return COMMAND_NANE;
    }

    public byte getLifecycle() {
        return this.lifecycle;
    }
}

