/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.List;
import jeus.jms.common.destination.JeusDestination;
import jeus.jms.common.destination.JeusQueue;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;

public class InsertDestinationCommand
extends SimpleSQLCommand {
    public static final String COMMAND_NAME = "INSERT_DESTINATION";
    private JeusDestination destination;
    private long version;

    public InsertDestinationCommand(DatabaseStorage storage, JeusDestination destination, long version) {
        super(storage);
        this.destination = destination;
        this.version = version;
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("INSERT INTO ").append(this.storage.getDestinationTableName()).append("(");
        buffer.append("DT_ID").append(", ");
        buffer.append("DT_NAME").append(", ");
        buffer.append("DT_EXPORT_NAME").append(", ");
        buffer.append("DT_TYPE").append(", ");
        buffer.append("DT_BROKER_NAME").append(", ");
        buffer.append("DT_CONSUMER_LIMIT").append(", ");
        buffer.append("DT_CAPACITY_LOW_MARK").append(", ");
        buffer.append("DT_CAPACITY_HIGH_MARK").append(", ");
        buffer.append("DT_CAPACITY_LIMIT").append(", ");
        buffer.append("DT_MAX_PENDING_LIMIT").append(", ");
        buffer.append("DT_RESUME_DISPATCH_FACTOR").append(", ");
        buffer.append("DT_WEIGHT").append(", ");
        buffer.append("DT_DISTRIBUTE_TYPE").append(", ");
        buffer.append("DT_LOCAL_DISTRIBUTE_TYPE").append(", ");
        buffer.append("DT_MULTIPLE_RECEIVER").append(", ");
        buffer.append("DT_RELAY_TYPE").append(", ");
        buffer.append("DT_RELAYS").append(", ");
        buffer.append("DT_VALID").append(",  ");
        buffer.append("DT_VERSION").append(") ");
        buffer.append(" VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        return buffer.toString();
    }

    public SQLParameter[] getSQLParameters() {
        return new SQLParameter[]{new SQLParameter("DT_ID", String.valueOf(this.destination.getId())), new SQLParameter("DT_NAME", this.destination.getLocalName()), new SQLParameter("DT_EXPORT_NAME", this.destination.getExportName()), new SQLParameter("DT_TYPE", String.valueOf(this.destination.getType())), new SQLParameter("DT_VERSION", String.valueOf(this.version))};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        PreparedStatement stmt = connection.prepareStatement(this.getSQL());
        try {
            stmt.setLong(1, this.destination.getId());
            stmt.setString(2, this.destination.getLocalName());
            stmt.setString(3, this.destination.getExportName());
            stmt.setByte(4, this.destination.getType());
            stmt.setString(5, this.destination.getBrokerName());
            stmt.setInt(6, this.destination.getConsumerLimit());
            stmt.setLong(7, this.destination.getLowMark());
            stmt.setLong(8, this.destination.getHighMark());
            stmt.setLong(9, this.destination.getLimit());
            stmt.setInt(10, this.destination.getMaxPendingLimit());
            stmt.setFloat(11, this.destination.getResumeDispatchFactor());
            if (this.destination.getType() == 81) {
                JeusQueue queue = (JeusQueue)this.destination;
                stmt.setInt(12, queue.getPreference());
                stmt.setByte(13, queue.getDistributeType());
                stmt.setByte(14, queue.getLocalDistributeType());
                stmt.setBoolean(15, queue.isPermitMultipleReceiver());
                stmt.setByte(16, queue.getRelayType());
                List relayList = queue.getRelays();
                if (relayList != null && !relayList.isEmpty()) {
                    StringBuffer buf = new StringBuffer();
                    Iterator i = relayList.iterator();
                    while (i.hasNext()) {
                        String relay = (String)i.next();
                        buf.append(relay);
                        if (!i.hasNext()) continue;
                        buf.append(",");
                    }
                    stmt.setString(17, buf.toString());
                } else {
                    stmt.setString(17, null);
                }
            } else {
                stmt.setInt(12, 1);
                stmt.setByte(13, (byte)0);
                stmt.setByte(14, (byte)0);
                stmt.setBoolean(15, false);
                stmt.setByte(16, (byte)0);
                stmt.setString(17, null);
            }
            stmt.setBoolean(18, true);
            stmt.setLong(19, this.version);
            stmt.executeUpdate();
        }
        finally {
            stmt.close();
        }
    }

    public String getName() {
        return COMMAND_NAME;
    }
}

