/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Map;
import jeus.jms.common.message.MessageProperty;
import jeus.jms.server.persistence.database.DatabasePlatform;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;

public class InsertUserPropertiesCommand
extends SimpleSQLCommand {
    public static final String COMMAND_NAME = "INSERT_USER_PROPERTIES";
    private long id;
    private MessageProperty props;

    public InsertUserPropertiesCommand(DatabaseStorage storage, long id, MessageProperty props) {
        super(storage);
        this.id = id;
        this.props = props;
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("INSERT INTO ").append(this.storage.getUserPropertyTableName()).append("(");
        buffer.append("MG_ID").append(", ");
        buffer.append("UP_NAME").append(", ");
        buffer.append("UP_TYPE").append(", ");
        buffer.append("UP_BOOLEAN").append(", ");
        buffer.append("UP_BYTE").append(", ");
        buffer.append("UP_SHORT").append(", ");
        buffer.append("UP_INT").append(", ");
        buffer.append("UP_LONG").append(", ");
        buffer.append("UP_FLOAT").append(", ");
        buffer.append("UP_DOUBLE").append(", ");
        buffer.append("UP_STRING").append(") ");
        buffer.append(" VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        DatabasePlatform platform = this.storage.getDatabasePlatform();
        PreparedStatement stmt = connection.prepareStatement(this.getSQL());
        try {
            for (Map.Entry entry : this.props.entrySet()) {
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                byte type = this.getPropertyType(value);
                stmt.setLong(1, this.id);
                stmt.setString(2, name);
                stmt.setByte(3, type);
                if (type == 2) {
                    stmt.setBoolean(4, (Boolean)value);
                } else {
                    stmt.setNull(4, platform.getSqlType(Boolean.class));
                }
                if (type == 3) {
                    stmt.setByte(5, (Byte)value);
                } else {
                    stmt.setNull(5, platform.getSqlType(Byte.class));
                }
                if (type == 8) {
                    stmt.setShort(6, (Short)value);
                } else {
                    stmt.setNull(6, platform.getSqlType(Short.class));
                }
                if (type == 1) {
                    stmt.setInt(7, (Integer)value);
                } else {
                    stmt.setNull(7, platform.getSqlType(Integer.class));
                }
                if (type == 7) {
                    stmt.setLong(8, (Long)value);
                } else {
                    stmt.setNull(8, platform.getSqlType(Long.class));
                }
                if (type == 4) {
                    stmt.setFloat(9, ((Float)value).floatValue());
                } else {
                    stmt.setNull(9, platform.getSqlType(Float.class));
                }
                if (type == 5) {
                    stmt.setDouble(10, (Double)value);
                } else {
                    stmt.setNull(10, platform.getSqlType(Double.class));
                }
                if (type == 6) {
                    stmt.setString(11, (String)value);
                } else {
                    stmt.setNull(11, platform.getSqlType(String.class));
                }
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        finally {
            stmt.close();
        }
    }

    private byte getPropertyType(Object value) {
        if (value.getClass() == Boolean.class) {
            return 2;
        }
        if (value.getClass() == Byte.class) {
            return 3;
        }
        if (value.getClass() == Short.class) {
            return 8;
        }
        if (value.getClass() == Integer.class) {
            return 1;
        }
        if (value.getClass() == Long.class) {
            return 7;
        }
        if (value.getClass() == Float.class) {
            return 4;
        }
        if (value.getClass() == Double.class) {
            return 5;
        }
        if (value.getClass() == String.class) {
            return 6;
        }
        throw new IllegalArgumentException();
    }

    public String getName() {
        return COMMAND_NAME;
    }
}

