/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.jms.server.persistence.database.command.SimpleSQLCommand;

public class RangeDeleteStaleMessagesCommand
extends SimpleSQLCommand {
    public static final String COMMAND_NAME = "RANGE_DELETE_STALE_MESSAGES";
    private long destinationId;
    private long version;
    private long from;
    private long to;

    public RangeDeleteStaleMessagesCommand(DatabaseStorage storage, long destinationId, long version, long from, long to) {
        super(storage);
        this.destinationId = destinationId;
        this.version = version;
        this.from = from;
        this.to = to;
    }

    protected String createSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DELETE FROM ").append(this.storage.getMessageTableName()).append(" WHERE ");
        buffer.append("DT_ID").append("=? AND ");
        buffer.append("MG_VERSION").append("<=? AND ");
        buffer.append("MG_ID").append(" BETWEEN ? AND ? ");
        return buffer.toString();
    }

    public SQLParameter[] getSQLParameters() {
        return new SQLParameter[]{new SQLParameter("DT_ID", String.valueOf(this.destinationId)), new SQLParameter("MG_VERSION", String.valueOf(this.version)), new SQLParameter("MG_ID", String.valueOf(this.from)), new SQLParameter("MG_ID", String.valueOf(this.to))};
    }

    public boolean isSynchronous() {
        return false;
    }

    public boolean isHighPriority() {
        return false;
    }

    public boolean waitForIdle() {
        return true;
    }

    public boolean retry() {
        return true;
    }

    public String getName() {
        return COMMAND_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection) throws Exception {
        PreparedStatement stmt = connection.prepareStatement(this.getSQL());
        try {
            stmt.setLong(1, this.destinationId);
            stmt.setLong(2, this.version);
            stmt.setLong(3, this.from);
            stmt.setLong(4, this.to);
            stmt.executeUpdate();
        }
        finally {
            stmt.close();
        }
    }
}

