/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.persistence.database.command;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import jeus.jms.server.persistence.database.DatabaseConstants;
import jeus.jms.server.persistence.database.DatabasePlatform;
import jeus.jms.server.persistence.database.DatabaseStorage;
import jeus.jms.server.persistence.database.SQLCommand;
import jeus.jms.server.persistence.database.SQLParameter;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public abstract class SQLCommandBase
implements SQLCommand,
DatabaseConstants {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms.server.persistence");
    protected DatabaseStorage storage;

    protected SQLCommandBase(DatabaseStorage storage) {
        this.storage = storage;
    }

    public boolean isAutoCommit() {
        return true;
    }

    public boolean isHighPriority() {
        return true;
    }

    public boolean isSynchronous() {
        return true;
    }

    public boolean waitForIdle() {
        return false;
    }

    public boolean retry() {
        return false;
    }

    protected final byte[] getBlobData(ResultSet rs, String columnName, int length) throws Exception {
        byte[] data;
        InputStream input = this.getBlobInputStream(rs, columnName);
        int result = input.read(data = new byte[length]);
        if (result != length) {
            throw new IOException("Retrieved data's length mismatch. Expected length is " + length + ", but " + result);
        }
        return data;
    }

    protected InputStream getBlobInputStream(ResultSet rs, String columnName) throws Exception {
        Blob blob = rs.getBlob(columnName);
        return blob.getBinaryStream();
    }

    protected DataInput getBlobDataInput(ResultSet rs, String columnName) throws Exception {
        return new DataInputStream(this.getBlobInputStream(rs, columnName));
    }

    public SQLParameter[] getSQLParameters() {
        return new SQLParameter[0];
    }

    public void log() {
        SQLParameter[] params;
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5441_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._5441_LEVEL, JeusMessage_JMS5._5441, new Object[]{this.getName(), this.getSQL()});
        }
        if ((params = this.getSQLParameters()) != null && params.length > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("(");
            for (int i = 0; i < params.length; ++i) {
                SQLParameter param = params[i];
                buffer.append(param.getName()).append("=").append(param.getValue());
                if (i >= params.length - 1) continue;
                buffer.append(",");
            }
            buffer.append(")");
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._5442_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._5442_LEVEL, JeusMessage_JMS5._5442, new Object[]{this.getName(), buffer.toString()});
            }
        }
    }

    public DatabasePlatform getDatabasePlatform() {
        return this.storage.getDatabasePlatform();
    }
}

