/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.transaction;

import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import jeus.jms.common.util.JMSXid;
import jeus.jms.server.transaction.TransactionBranch;
import jeus.jms.server.transaction.TransactionManager;
import jeus.jms.server.transaction.TransactionalWorks;

public class SharedTransactionContext {
    private boolean xaTransacted;
    private boolean localTransacted;
    private TransactionalWorks context;

    public TransactionalWorks getTransactionContext() {
        return this.context;
    }

    public void beginLocalTransaction() throws JMSException {
        if (this.context != null && !this.context.isCompleted()) {
            throw new JMSException("nested transaction is not supported");
        }
        this.context = new TransactionalWorks();
        this.localTransacted = true;
    }

    public void commitLocalTransaction() throws JMSException {
        if (this.context == null || this.context instanceof TransactionBranch) {
            throw new JMSException("invalid transaction protocol");
        }
        this.context.commitLocalTransaction();
    }

    public void rollbackLocalTransaction() throws JMSException {
        if (this.context == null || this.context instanceof TransactionBranch) {
            throw new JMSException("invalid transaction protocol");
        }
        this.context.rollbackLocalTransaction();
    }

    public void startGlobalTransaction(JMSXid xid, int flag, long timeout, boolean remote) throws XAException {
        if (this.context != null && !this.context.isCompleted()) {
            throw new XAException(-6);
        }
        this.context = TransactionManager.getInstance().startTransaction(xid, flag, timeout, remote);
        this.xaTransacted = true;
    }

    public void endGlobalTransaction(JMSXid xid, int flag, long timeout) throws XAException {
        if (!(this.context instanceof TransactionBranch)) {
            throw new XAException(-6);
        }
        TransactionBranch branch = (TransactionBranch)this.context;
        if (!branch.denotes(xid)) {
            throw new XAException(-6);
        }
        branch.end(flag, timeout);
    }

    public boolean isLocalTransacted() {
        return this.context != null && !this.context.isCompleted() && this.localTransacted;
    }

    public boolean isXATransacted() {
        return this.context != null && !this.context.isCompleted() && this.xaTransacted;
    }

    public boolean isTransacted() {
        return this.context != null && !this.context.isCompleted() && (this.localTransacted || this.xaTransacted);
    }
}

