/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.transaction;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import jeus.jms.common.message.ISerializable;
import jeus.jms.common.util.JMSXid;
import jeus.jms.server.manager.DestinationManager;
import jeus.jms.server.manager.TransactedSubscription;
import jeus.jms.server.message.ServerMessage;
import jeus.jms.server.transaction.TransactionContext;
import jeus.jms.server.transaction.TransactionalWorks;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class TransactionBranch
extends TransactionalWorks
implements ISerializable {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    public static final int MAX_SIZE = 160;
    protected JMSXid xid;
    protected transient int endState;
    protected transient TransactionContext context;

    public TransactionBranch(TransactionContext context, JMSXid xid) {
        this.context = context;
        this.setTransactionID(xid);
        this.initialize();
    }

    public boolean isXa() {
        return true;
    }

    public void initialize() {
        this.setState(6);
        this.endState = -1;
    }

    public String getEndStatusString() {
        return this.getString(this.endState);
    }

    public JMSXid getTransactionID() {
        return this.xid;
    }

    public void setTransactionID(JMSXid xid) {
        this.xid = xid;
    }

    public void setRollbackOnly() {
        super.setRollbackOnly();
        this.context.setRollbackOnly();
    }

    public void start(int flag, long timeout) throws XAException {
        switch (this.getState()) {
            case 6: {
                if (flag != 0) {
                    throw new XAException(-5);
                }
                this.start(this.xid, flag, timeout);
                this.setState(0);
                break;
            }
            case 0: {
                if (flag == 0x200000) {
                    if (this.endState == 10) break;
                    throw new XAException(-6);
                }
                if (flag == 0x8000000) {
                    if (this.endState == 12) break;
                    throw new XAException(-6);
                }
                throw new XAException(-5);
            }
            default: {
                throw new XAException(-6);
            }
        }
    }

    public void end(int flag, long timeout) throws XAException {
        switch (this.getState()) {
            case 0: {
                if (flag == 0x2000000) {
                    this.endState = 12;
                    break;
                }
                if (flag == 0x4000000 || flag == 0) {
                    if (this.endState != -1) break;
                    try {
                        this.end(this.xid, flag, timeout);
                        this.endState = 10;
                        break;
                    }
                    catch (XAException e) {
                        this.endState = 11;
                        this.setState(1);
                        throw e;
                    }
                }
                if (flag == 0x20000000) {
                    this.endState = 11;
                    this.setState(1);
                    break;
                }
                throw new XAException(-5);
            }
            default: {
                throw new XAException(-6);
            }
        }
    }

    public void recoveredProduce(ServerMessage message, DestinationManager manager, byte lifeCycle) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7131_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7131_LEVEL, JeusMessage_JMS5._7131, new Object[]{this, new Byte(lifeCycle)});
        }
        this.addProducer(message, manager);
    }

    public void recoveredConsume(ServerMessage message, TransactedSubscription manager, byte lifeCycle) throws JMSException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7132_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7132_LEVEL, JeusMessage_JMS5._7132, new Object[]{this, new Byte(lifeCycle)});
        }
        manager.recoveredConsume(message, lifeCycle);
        this.addConsumer(message, manager);
    }

    public boolean denotes(JMSXid xid) {
        return this.xid.equals(xid);
    }

    public void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.getState());
        this.xid.writeExternal(out);
    }

    public void readExternal(DataInput in) throws IOException {
        this.setState(in.readInt());
        this.xid.readExternal(in);
    }

    public String toString() {
        return this.getStatusString() + "::" + this.xid.toString();
    }
}

