/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.transaction;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TimerTask;
import javax.jms.JMSException;
import javax.jms.TransactionRolledBackException;
import javax.transaction.Status;
import javax.transaction.xa.XAException;
import jeus.jms.common.message.MessageID;
import jeus.jms.common.util.JMSExceptionFactory;
import jeus.jms.common.util.JMSXid;
import jeus.jms.server.JMSConnection;
import jeus.jms.server.manager.DestinationManager;
import jeus.jms.server.manager.Scheduler;
import jeus.jms.server.manager.StorageManager;
import jeus.jms.server.manager.SubscriptionManager;
import jeus.jms.server.manager.TransactedDestination;
import jeus.jms.server.manager.TransactedSubscription;
import jeus.jms.server.message.ServerMessage;
import jeus.jms.server.persistence.GlobalTransactionContext;
import jeus.jms.server.persistence.LocalTransactionContext;
import jeus.jms.server.persistence.Storage;
import jeus.jms.server.persistence.StorageException;
import jeus.jms.server.persistence.StorageTransactionContext;
import jeus.jms.server.transaction.TransactionalWork;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS5;

public class TransactionalWorks
implements Status {
    private static JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");
    public static final int PREPARE = 0;
    public static final int COMMIT = 1;
    public static final int ROLLBACK = 2;
    public static final int END_STATUS_NONE = -1;
    public static final int END_STATUS_SUCCESS = 10;
    public static final int END_STATUS_FAIL = 11;
    public static final int END_STATUS_SUSPEND = 12;
    private int state;
    private transient List works = Collections.synchronizedList(new LinkedList());
    private transient Storage storage = StorageManager.getCurrentStorage();
    private long timeout = 0L;
    private TimerTask timeoutTask;
    private long startTime;
    private int executedWorks;
    private boolean readOnly = false;

    public boolean isXa() {
        return false;
    }

    public void addWork(TransactionalWork provider) {
        this.works.add(provider);
    }

    public void addWorks(List providers) {
        this.works.addAll(providers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getWorks() {
        List list = this.works;
        synchronized (list) {
            List list2;
            try {
                list2 = this.works.isEmpty() ? Collections.EMPTY_LIST : new LinkedList(this.works);
                this.works.clear();
            }
            catch (Throwable throwable) {
                this.works.clear();
                throw throwable;
            }
            return list2;
        }
    }

    public void addTemporaryProducer(ServerMessage message, JMSConnection connection) {
        TransactedTemporaryProducer producer = new TransactedTemporaryProducer(message, connection);
        this.addWork(producer);
    }

    public void addProducer(ServerMessage message, DestinationManager manager) throws JMSException {
        TransactionalWork provider = this.createTransactedProducer(message, manager);
        this.addWork(provider);
    }

    public void addConsumer(ServerMessage messsage, TransactedSubscription manager) throws JMSException {
        TransactionalWork consumer = this.createTransactedConsumer(messsage, manager);
        this.addWork(consumer);
    }

    public void addConsumer(MessageID messageID, SubscriptionManager manager) throws JMSException {
        ServerMessage messsage = manager.getAcknowledge(messageID);
        this.addConsumer(messsage, (TransactedSubscription)manager);
    }

    private TransactionalWork createTransactedProducer(ServerMessage message, DestinationManager manager) throws JMSException {
        return new TransactedProducer(message, manager);
    }

    private TransactionalWork createTransactedConsumer(ServerMessage messsage, TransactedSubscription manager) throws JMSException {
        return new TransactedConsumer(messsage, manager);
    }

    public synchronized boolean isCompleted() {
        return this.state == 3 || this.state == 4;
    }

    public synchronized int getState() {
        return this.state;
    }

    public synchronized void setState(int state) {
        this.state = state;
    }

    public synchronized void setRollbackOnly() {
        switch (this.state) {
            case 3: 
            case 4: 
            case 9: {
                return;
            }
        }
        this.setState(1);
    }

    protected void start(JMSXid xid, int flag, long timeout) throws XAException {
        this.startTime = System.currentTimeMillis();
    }

    private void checkTimeout(GlobalTransactionContext context, long timeout) throws XAException {
        long elapsedTime;
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7071_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7071_LEVEL, JeusMessage_JMS5._7071, new Object[]{new Long(this.timeout), new Long(timeout)});
        }
        if ((elapsedTime = System.currentTimeMillis() - this.startTime) > timeout) {
            throw new XAException(106);
        }
        long remainingTimeout = timeout - elapsedTime;
        if (this.timeout != timeout) {
            this.setTransactionTimeout(context, timeout);
            this.timeout = timeout;
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel();
            }
            this.timeoutTask = new TransactionTimeoutTask(this);
            Scheduler.scheduleTask(this.timeoutTask, remainingTimeout);
        }
    }

    private void setTransactionTimeout(GlobalTransactionContext context, long timeout) throws XAException {
        if (context != null) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7072_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._7072_LEVEL, JeusMessage_JMS5._7072, new Integer((int)(timeout / 1000L)));
            }
            context.setTransactionTimeout((int)(timeout / 1000L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void end(JMSXid xid, int flag, long timeout) throws XAException {
        if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7073_LEVEL)) {
            LogUtils.log(logger, JeusMessage_JMS5._7073_LEVEL, JeusMessage_JMS5._7073, xid.toString());
        }
        if (this.works.isEmpty()) {
            return;
        }
        Storage storage = StorageManager.getCurrentStorage();
        GlobalTransactionContext context = storage.createGlobalTransactionContext(this);
        try {
            this.checkTimeout(context, timeout);
            context.start(xid, 0);
        }
        catch (XAException xae) {
            storage.handleXAException(xae);
            context.releaseResource();
            throw xae;
        }
        context.preExecute();
        JMSException workException = null;
        try {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7074_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._7074_LEVEL, JeusMessage_JMS5._7074, new Integer(this.works.size()));
            }
            for (TransactionalWork work : this.works) {
                work.execute(context);
                ++this.executedWorks;
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
            workException = e;
        }
        finally {
            context.postExecute();
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7075_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._7075_LEVEL, JeusMessage_JMS5._7075, new Integer(this.executedWorks));
            }
        }
        try {
            context.end(xid, workException == null ? 0x4000000 : 0x20000000);
        }
        catch (XAException e) {
            storage.handleXAException(e);
            throw e;
        }
        finally {
            context.releaseResource();
        }
        if (workException != null) {
            throw new XAException(-3);
        }
    }

    public synchronized int prepare(JMSXid xid, long timeout) throws XAException {
        if (this.state == 1) {
            this.rollback(xid);
            throw new XAException(100);
        }
        if (this.works.isEmpty()) {
            this.readOnly = true;
            this.setState(3);
            return 3;
        }
        this.setState(7);
        int result = this.executePrepare(xid, timeout);
        this.setState(2);
        if (result == 3) {
            this.setState(3);
        }
        return result;
    }

    private synchronized int executePrepare(JMSXid xid, long timeout) throws XAException {
        Storage storage = StorageManager.getCurrentStorage();
        GlobalTransactionContext context = storage.createGlobalTransactionContext(this);
        try {
            this.readOnly = context.prepare(xid) == 3;
            int n = this.executedWorks == 0 && this.readOnly ? 3 : 0;
            return n;
        }
        catch (XAException e) {
            storage.handleXAException(e);
            throw e;
        }
        finally {
            context.releaseResource();
        }
    }

    public synchronized boolean commit(JMSXid xid, boolean onePhase, long timeout) throws XAException {
        boolean result;
        if (this.getState() == 1) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7076_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._7076_LEVEL, JeusMessage_JMS5._7076);
            }
            this.rollback(xid);
            throw new XAException(100);
        }
        this.setState(8);
        try {
            result = this.works.isEmpty() || (onePhase ? this.executeOnephaseCommit(xid, timeout) : this.executeCommit(xid, timeout));
        }
        catch (XAException xaEx) {
            if (xaEx.errorCode == 100) {
                this.setState(4);
            }
            throw xaEx;
        }
        this.setState(3);
        return result;
    }

    private synchronized boolean executeOnephaseCommit(JMSXid xid, long timeout) throws XAException {
        Storage storage = StorageManager.getCurrentStorage();
        GlobalTransactionContext context = storage.createGlobalTransactionContext(this);
        try {
            context.commit(xid, true);
        }
        catch (XAException e) {
            storage.handleXAException(e);
            throw e;
        }
        finally {
            context.releaseResource();
        }
        if (!this.commitWorks()) {
            this.completed();
            throw new XAException(5);
        }
        return this.completed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private synchronized boolean executeCommit(JMSXid xid, long timeout) throws XAException {
        if (LogUtils.isLoggable(TransactionalWorks.logger, JeusMessage_JMS5._7077_LEVEL)) {
            LogUtils.log(TransactionalWorks.logger, JeusMessage_JMS5._7077_LEVEL, JeusMessage_JMS5._7077, this.readOnly);
        }
        if (!this.readOnly) {
            storage = StorageManager.getCurrentStorage();
            context = storage.createGlobalTransactionContext(this);
            try {
                context.commit(xid, false);
            }
            catch (XAException xae) {
                switch (xae.errorCode) {
                    case 5: 
                    case 6: 
                    case 7: {
                        ** break;
lbl13:
                        // 1 sources

                        break;
                    }
                    default: {
                        storage.handleXAException(xae);
                        throw xae;
                    }
                }
            }
            finally {
                context.releaseResource();
            }
        }
        if (!this.commitWorks()) {
            this.completed();
            throw new XAException(5);
        }
        return this.completed();
    }

    private boolean commitWorks() {
        boolean success = true;
        for (TransactionalWork work : this.works) {
            success = work.commit();
        }
        return success;
    }

    public synchronized boolean commitLocalTransaction() throws JMSException {
        return this.commitLocalTransaction(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean commitLocalTransaction(boolean rollback) throws JMSException {
        if (this.state == 1) {
            this.rollbackLocalTransaction();
            throw new TransactionRolledBackException("transaction is marked rollback");
        }
        this.setState(8);
        try {
            boolean bl = this.executeLocalCommit(rollback);
            return bl;
        }
        finally {
            this.setState(3);
        }
    }

    private synchronized boolean executeLocalCommit(boolean rollback) throws JMSException {
        LocalTransactionContext context;
        Storage storage = StorageManager.getCurrentStorage();
        if (!storage.supportsLocalTransaction()) {
            return true;
        }
        try {
            context = storage.createLocalTransactionContext();
        }
        catch (StorageException e) {
            this.rollbackLocalTransaction();
            TransactionRolledBackException rollbackEx = new TransactionRolledBackException(e.getMessage());
            rollbackEx.setLinkedException((Exception)((Object)e));
            throw rollbackEx;
        }
        try {
            for (TransactionalWork work : this.works) {
                work.execute(context);
            }
            if (rollback) {
                throw JMSExceptionFactory.createJMSException("Transaction is rolled back.", null);
            }
            context.commit();
            for (TransactionalWork work : this.works) {
                work.commit();
            }
        }
        catch (JMSException e) {
            try {
                context.rollback();
            }
            catch (StorageException se) {
                se.printStackTrace();
            }
            this.rollbackLocalTransaction();
            TransactionRolledBackException rollbackEx = new TransactionRolledBackException(e.getMessage());
            rollbackEx.setLinkedException((Exception)((Object)e));
            throw rollbackEx;
        }
        finally {
            context.releaseResource();
        }
        return this.completed();
    }

    public synchronized boolean rollback(JMSXid xid) throws XAException {
        return this.rollback(null, xid);
    }

    public synchronized boolean rollback(GlobalTransactionContext context, JMSXid xid) throws XAException {
        this.setState(9);
        try {
            if (this.executedWorks > 0) {
                if (!this.readOnly) {
                    if (context == null) {
                        context = StorageManager.getCurrentStorage().createGlobalTransactionContext(this);
                    }
                    context.rollback(xid);
                }
                boolean bl = this.rollbackWorks();
                return bl;
            }
            boolean bl = this.completed();
            return bl;
        }
        catch (XAException e) {
            switch (e.errorCode) {
                case 5: 
                case 6: 
                case 7: {
                    boolean bl = this.rollbackWorks();
                    return bl;
                }
            }
            e.printStackTrace();
            this.storage.handleXAException(e);
            throw e;
        }
        finally {
            if (context != null) {
                context.releaseResource();
            }
            this.setState(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean rollbackLocalTransaction() {
        this.setState(9);
        try {
            boolean bl = this.rollbackWorks();
            return bl;
        }
        finally {
            this.setState(4);
        }
    }

    private synchronized boolean rollbackWorks() {
        for (TransactionalWork work : this.works) {
            work.rollback();
        }
        return this.completed();
    }

    public void forget(JMSXid xid) throws XAException {
        GlobalTransactionContext context = this.storage.createGlobalTransactionContext(this);
        try {
            context.forget(xid);
        }
        catch (XAException e) {
            this.storage.handleXAException(e);
            throw e;
        }
        finally {
            context.releaseResource();
        }
        this.rollbackWorks();
    }

    public synchronized void clearWorks() {
        this.works.clear();
    }

    public synchronized boolean isEmpty() {
        return this.works.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean completed() {
        try {
            boolean bl = !this.works.isEmpty();
            return bl;
        }
        finally {
            this.works.clear();
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel();
            }
        }
    }

    public synchronized String getStatusString() {
        return this.getString(this.state);
    }

    public String getString(int value) {
        switch (value) {
            case 0: {
                return "STATUS_ACTIVE";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 3: {
                return "STATUS_COMMITTED";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 7: {
                return "STATUS_PREPARING";
            }
            case 8: {
                return "STATUS_COMMITTING";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
            case 10: {
                return "END_STATUS_SUCCESS";
            }
            case 11: {
                return "END_STATUS_FAIL";
            }
            case 12: {
                return "END_STATUS_SUSPEND";
            }
        }
        return "invalid state " + value;
    }

    class TransactionTimeoutTask
    extends TimerTask {
        private TransactionalWorks txWorks;

        public TransactionTimeoutTask(TransactionalWorks txWorks) {
            this.txWorks = txWorks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            TransactionalWorks transactionalWorks = this.txWorks;
            synchronized (transactionalWorks) {
                switch (this.txWorks.getState()) {
                    case 0: 
                    case 3: 
                    case 4: 
                    case 9: {
                        break;
                    }
                    default: {
                        TransactionalWorks.this.rollbackLocalTransaction();
                    }
                }
            }
        }
    }

    protected class TransactedTemporaryProducer
    implements TransactionalWork {
        private JMSConnection connection;
        private ServerMessage message;

        public TransactedTemporaryProducer(ServerMessage message, JMSConnection connection) {
            this.message = message;
            this.connection = connection;
        }

        public boolean execute(StorageTransactionContext txCtx) throws JMSException {
            return false;
        }

        public boolean commit() {
            try {
                this.connection.sendMessage(this.message);
            }
            catch (JMSException e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }

        public void rollback() {
        }
    }

    protected class TransactedConsumer
    implements TransactionalWork {
        private TransactedSubscription manager;
        private ServerMessage message;

        TransactedConsumer(ServerMessage message, TransactedSubscription manager) {
            this.message = message;
            this.manager = manager;
        }

        public boolean execute(StorageTransactionContext context) throws JMSException {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7079_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._7079_LEVEL, JeusMessage_JMS5._7079, new Long(this.message.getId()));
            }
            this.engage();
            return this.manager.prepareConsume(context, this.message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean commit() {
            try {
                this.message.setTransacted(false);
                this.manager.commitConsume(this.message);
            }
            finally {
                this.release();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rollback() {
            try {
                this.message.setTransacted(false);
                this.manager.rollbackConsume(this.message);
            }
            finally {
                this.release();
            }
        }

        private void engage() {
            this.manager.enlisted(TransactionalWorks.this);
        }

        private void release() {
            this.manager.delisted(TransactionalWorks.this);
        }
    }

    protected class TransactedProducer
    implements TransactionalWork {
        private TransactedDestination manager;
        private ServerMessage message;

        TransactedProducer(ServerMessage message, TransactedDestination manager) {
            this.message = message;
            this.manager = manager;
        }

        public boolean execute(StorageTransactionContext context) throws JMSException {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS5._7078_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS5._7078_LEVEL, JeusMessage_JMS5._7078, new Long(this.message.getId()));
            }
            this.engage();
            return this.manager.prepareProduce(context, this.message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean commit() {
            try {
                this.message.setTransacted(false);
                this.manager.commitProduce(this.message);
            }
            finally {
                this.release();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rollback() {
            try {
                this.message.setTransacted(false);
                this.manager.rollbackProduce(this.message);
            }
            finally {
                this.release();
            }
        }

        private void engage() {
            this.manager.enlisted(TransactionalWorks.this);
        }

        private void release() {
            this.manager.delisted(TransactionalWorks.this);
        }
    }
}

