/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.server.util;

import javax.jms.JMSException;
import jeus.jms.common.util.ExecutionResult;
import jeus.jms.server.message.ServerMessage;

public abstract class ExecutionCycle
implements ExecutionResult {
    public void workStarted() {
    }

    public boolean startWork(ServerMessage message) {
        int result;
        this.preExecution(message);
        try {
            result = this.execute(message) ? 0 : 1;
        }
        catch (JMSException e) {
            result = 2;
            this.exception(message, e);
        }
        catch (Throwable t) {
            result = 3;
            this.failed(message, t);
        }
        return this.postExecution(message, result);
    }

    public void preExecution(ServerMessage message) {
    }

    public abstract boolean execute(ServerMessage var1) throws Exception;

    public boolean postExecution(ServerMessage message, int result) {
        return true;
    }

    public void exception(ServerMessage message, JMSException e) {
        e.printStackTrace();
    }

    public void failed(ServerMessage message, Throwable t) {
        t.printStackTrace();
    }

    public void worksCompleted() {
    }
}

