/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.wrapper;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import jeus.descriptor.extresource.JMSSourceDescriptor;
import jeus.descriptor.jeusserver.ConnectorProperty;
import jeus.jms.wrapper.XAQueueConnectionFactoryWrapper;
import jeus.jms.wrapper.XATopicConnectionFactoryWrapper;
import jeus.util.JeusException;
import jeus.util.JeusRootClassLoader;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS12;

public class JMSSourceBinder {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    public static boolean bind(JMSSourceDescriptor desc) {
        try {
            Object resource;
            Object[] args;
            Constructor<?> cons;
            Class[] argTypes;
            String vendor = desc.getVendor();
            Class<?> cl = JMSSourceBinder.getDSClassLoader().loadClass(desc.getFacotyClass());
            Object src = new Object();
            if (vendor.equals("ibmmq") && desc.getResourceType() == 3) {
                argTypes = new Class[]{String.class, String.class};
                cons = cl.getConstructor(argTypes);
                args = new Object[]{desc.getQmanager(), desc.getQueue()};
                src = cons.newInstance(args);
            } else if (vendor.equals("sonicmq") && desc.getResourceType() == 3) {
                argTypes = new Class[]{String.class};
                cons = cl.getConstructor(argTypes);
                args = new Object[]{desc.getQueue()};
                src = cons.newInstance(args);
            } else if (desc.getResourceType() == 4) {
                argTypes = new Class[]{String.class};
                cons = cl.getConstructor(argTypes);
                args = new Object[]{desc.getTopic()};
                src = cons.newInstance(args);
            } else {
                src = cl.newInstance();
            }
            argTypes = new Class[1];
            Object[] args2 = new Object[1];
            String name = "";
            if (vendor.equals("ibmmq") && desc.getResourceType() != 4 && desc.getResourceType() != 3) {
                argTypes[0] = String.class;
                args2[0] = desc.getQmanager();
                JMSSourceBinder.invokeMethod(cl, "setQueueManager", argTypes, src, args2);
            }
            Enumeration e = desc.properties.elements();
            while (e.hasMoreElements()) {
                ConnectorProperty property = (ConnectorProperty)e.nextElement();
                argTypes[0] = JMSSourceBinder.getTypeClass(property.getType());
                args2[0] = JMSSourceBinder.getValue(argTypes[0], property.getValue());
                name = property.getName().substring(0, 1).toUpperCase() + property.getName().substring(1);
                try {
                    JMSSourceBinder.invokeMethod(cl, "set" + name, argTypes, src, args2);
                }
                catch (NoSuchMethodException ex1) {
                    argTypes[0] = JMSSourceBinder.getWrapperClass(argTypes[0]);
                    JMSSourceBinder.invokeMethod(cl, "set" + name, argTypes, src, args2);
                }
            }
            switch (desc.getResourceType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    resource = src;
                    break;
                }
                case 5: {
                    resource = new XAQueueConnectionFactoryWrapper((QueueConnectionFactory)src, desc.getExportName(), false, desc.getResourceType(), vendor);
                    break;
                }
                case 6: {
                    resource = new XATopicConnectionFactoryWrapper((TopicConnectionFactory)src, desc.getExportName(), false, desc.getResourceType(), vendor);
                    break;
                }
                case 7: {
                    resource = new XAQueueConnectionFactoryWrapper((QueueConnectionFactory)src, desc.getExportName(), true, desc.getResourceType(), vendor);
                    break;
                }
                case 8: {
                    resource = new XATopicConnectionFactoryWrapper((TopicConnectionFactory)src, desc.getExportName(), true, desc.getResourceType(), vendor);
                    break;
                }
                default: {
                    throw new JeusException(13012);
                }
            }
            Hashtable<String, String> envs = new Hashtable<String, String>();
            envs.put("jeus.jndi.jns.replicatebindings", "false");
            envs.put("jeus.jndi.jns.forcedbindings", "true");
            InitialContext ctx = new InitialContext(envs);
            ctx.rebind(desc.getExportName(), resource);
            return true;
        }
        catch (Throwable t) {
            if (LogUtils.isLoggable(logger, JeusMessage_JMS12._12061_LEVEL)) {
                LogUtils.log(logger, JeusMessage_JMS12._12061_LEVEL, JeusMessage_JMS12._12061, desc.getExportName(), t);
            }
            return false;
        }
    }

    public static Class getTypeClass(String type) {
        if (type.equals("java.lang.Boolean")) {
            return Boolean.TYPE;
        }
        if (type.equals("java.lang.String")) {
            return String.class;
        }
        if (type.equals("java.lang.Integer")) {
            return Integer.TYPE;
        }
        if (type.equals("java.lang.Double")) {
            return Double.TYPE;
        }
        if (type.equals("java.lang.Byte")) {
            return Byte.TYPE;
        }
        if (type.equals("java.lang.Short")) {
            return Short.TYPE;
        }
        if (type.equals("java.lang.Long")) {
            return Long.TYPE;
        }
        if (type.equals("java.lang.Float")) {
            return Float.TYPE;
        }
        return Character.TYPE;
    }

    public static Class getWrapperClass(Class type) {
        if (type.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (type.equals(String.class)) {
            return String.class;
        }
        if (type.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (type.equals(Double.TYPE)) {
            return Double.class;
        }
        if (type.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (type.equals(Short.TYPE)) {
            return Short.class;
        }
        if (type.equals(Long.TYPE)) {
            return Long.class;
        }
        if (type.equals(Float.TYPE)) {
            return Float.class;
        }
        return Character.class;
    }

    public static Object getValue(Class type, String value) {
        if (type.equals(Boolean.TYPE)) {
            return new Boolean(value);
        }
        if (type.equals(String.class)) {
            return new String(value);
        }
        if (type.equals(Integer.TYPE)) {
            return new Integer(value);
        }
        if (type.equals(Double.TYPE)) {
            return new Double(value);
        }
        if (type.equals(Byte.TYPE)) {
            return new Byte(value);
        }
        if (type.equals(Short.TYPE)) {
            return new Short(value);
        }
        if (type.equals(Long.TYPE)) {
            return new Long(value);
        }
        if (type.equals(Float.TYPE)) {
            return new Float(value);
        }
        return new Character(value.charAt(0));
    }

    public static ClassLoader getDSClassLoader() {
        return JeusRootClassLoader.loader;
    }

    public static void invokeMethod(Class cl, String methodName, Class[] argTypes, Object instance, Object[] args) throws Exception {
        Method m = cl.getMethod(methodName, argTypes);
        m.invoke(instance, args);
    }
}

