/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.wrapper;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.jms.wrapper.JMSTransactionHandler;
import jeus.transaction.JeusXAException;
import jeus.transaction.resources.XAResourceWrapper;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.LogUtils;
import jeus.util.message.JeusMessage_JMS12;

public class JMSXAResourceWrapper
extends XAResourceWrapper {
    private JMSTransactionHandler handler;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.jms");

    public JMSXAResourceWrapper(XAResource resource, JMSTransactionHandler handler) {
        super(resource);
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enforceEnd() {
        if (this.inTx) {
            try {
                this.end(this.xid, 0x4000000);
            }
            catch (Throwable t) {
                if (LogUtils.isLoggable(logger, JeusMessage_JMS12._12001_LEVEL)) {
                    LogUtils.log(logger, JeusMessage_JMS12._12001_LEVEL, JeusMessage_JMS12._12001, t);
                }
            }
            finally {
                this.handler.enforceEnd();
            }
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.resource.commit(xid, onePhase);
        }
        catch (XAException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new JeusXAException(4907, t);
        }
    }

    public int prepare(Xid xid) throws XAException {
        try {
            return this.resource.prepare(xid);
        }
        catch (XAException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new JeusXAException(4908, t);
        }
    }

    public void rollback(Xid xid) throws XAException {
        try {
            this.resource.rollback(xid);
        }
        catch (XAException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new JeusXAException(4909, t);
        }
    }
}

