/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.wrapper;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.naming.Reference;
import jeus.jms.wrapper.ConnectionFactoryWrapper;
import jeus.jms.wrapper.XAQueueConnectionWrapper;

public class XAQueueConnectionFactoryWrapper
extends ConnectionFactoryWrapper
implements XAQueueConnectionFactory {
    private QueueConnectionFactory QConfactory;

    public XAQueueConnectionFactoryWrapper(QueueConnectionFactory QConfactory, String exportName, boolean isLocalTransaction, int resourceType, String vendor) {
        super(null, exportName, isLocalTransaction, resourceType, vendor);
        this.QConfactory = QConfactory;
    }

    public XAQueueConnectionFactoryWrapper(Reference ref, String exportName, boolean isLocalTransaction, int resourceType, String vendor) throws JMSException {
        super(ref, exportName, isLocalTransaction, resourceType, vendor);
        this.QConfactory = (QueueConnectionFactory)XAQueueConnectionFactoryWrapper.getFactoryFromReference(ref, exportName);
    }

    public XAConnection createXAConnection() throws JMSException {
        if (this.isLocalTransaction) {
            return new XAQueueConnectionWrapper(this.QConfactory.createQueueConnection(), true, this.vendor);
        }
        return new XAQueueConnectionWrapper((QueueConnection)((XAQueueConnectionFactory)this.QConfactory).createXAQueueConnection(), false, this.vendor);
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        if (this.isLocalTransaction) {
            return new XAQueueConnectionWrapper(this.QConfactory.createQueueConnection(), true, this.vendor);
        }
        return new XAQueueConnectionWrapper((QueueConnection)((XAQueueConnectionFactory)this.QConfactory).createXAQueueConnection(), false, this.vendor);
    }

    public XAConnection createXAConnection(String userName, String password) throws JMSException {
        if (this.isLocalTransaction) {
            return new XAQueueConnectionWrapper(this.QConfactory.createQueueConnection(userName, password), true, this.vendor);
        }
        return new XAQueueConnectionWrapper((QueueConnection)((XAQueueConnectionFactory)this.QConfactory).createXAQueueConnection(userName, password), false, this.vendor);
    }

    public XAQueueConnection createXAQueueConnection(String userName, String password) throws JMSException {
        if (this.isLocalTransaction) {
            return new XAQueueConnectionWrapper(this.QConfactory.createQueueConnection(userName, password), true, this.vendor);
        }
        return new XAQueueConnectionWrapper((QueueConnection)((XAQueueConnectionFactory)this.QConfactory).createXAQueueConnection(userName, password), false, this.vendor);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.createXAQueueConnection();
    }

    public Connection createConnection() throws JMSException {
        return this.createXAQueueConnection();
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return this.createXAQueueConnection(userName, password);
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        return this.createXAQueueConnection(userName, password);
    }

    public Object getDelegate() {
        return this.QConfactory;
    }
}

