/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.wrapper;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.jms.XAQueueSession;
import javax.transaction.xa.XAResource;
import jeus.jms.wrapper.JMSTransactionHandler;
import jeus.jms.wrapper.QueueReceiverWrapper;
import jeus.jms.wrapper.QueueSessionWrapper;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_JMS;

public class XAQueueSessionWrapper
extends JMSTransactionHandler
implements XAQueueSession {
    private QueueSession Qses;
    private boolean isLocalTransaction;
    private String vendor;

    public XAQueueSessionWrapper(Session Ses, boolean isLocalTransaction, String vendor) {
        super(Ses, isLocalTransaction);
        this.Qses = (QueueSession)Ses;
        this.isLocalTransaction = isLocalTransaction;
        this.vendor = vendor;
    }

    public QueueSession getQueueSession() throws JMSException {
        if (this.isLocalTransaction) {
            return new QueueSessionWrapper(this.Qses, true, this.vendor);
        }
        return new QueueSessionWrapper(((XAQueueSession)this.Qses).getQueueSession(), false, this.vendor);
    }

    public Session getSession() throws JMSException {
        return this.getQueueSession();
    }

    public XAResource getXAResource() {
        return ((XAQueueSession)this.Qses).getXAResource();
    }

    public boolean getTransacted() throws JMSException {
        return this.Qses.getTransacted();
    }

    public void commit() throws JMSException {
        throw new JMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4913));
    }

    public void rollback() throws JMSException {
        throw new JMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4914));
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.Qses.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.Qses.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.Qses.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.Qses.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return this.Qses.createObjectMessage(object);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.Qses.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.Qses.createTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        return this.Qses.createTextMessage(text);
    }

    public void close() throws JMSException {
        this.Qses.close();
    }

    public void recover() throws JMSException {
        this.Qses.recover();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.Qses.getMessageListener();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.Qses.setMessageListener(listener);
    }

    public void run() {
        this.Qses.run();
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.Qses.getAcknowledgeMode();
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        return this.Qses.createProducer(destination);
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return new QueueReceiverWrapper(this.Qses.createReceiver((Queue)destination), this);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return new QueueReceiverWrapper(this.Qses.createReceiver((Queue)destination, messageSelector), this);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        return new QueueReceiverWrapper(this.Qses.createReceiver((Queue)destination, messageSelector), this);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.Qses.createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        return this.Qses.createBrowser(queue, messageSelector);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        throw new IllegalStateException("Topic operation not supported");
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        throw new IllegalStateException("Topic operation not supported");
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        throw new IllegalStateException("Topic operation not supported");
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.Qses.createTemporaryQueue();
    }

    public Queue createQueue(String queueName) throws JMSException {
        return this.Qses.createQueue(queueName);
    }

    public Topic createTopic(String topicName) throws JMSException {
        throw new IllegalStateException("Topic operation not supported");
    }

    public void unsubscribe(String name) throws JMSException {
        throw new IllegalStateException("Topic operation not supported");
    }
}

