/*
 * Decompiled with CFR 0.152.
 */
package jeus.jms.wrapper;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.XATopicSession;
import javax.transaction.xa.XAResource;
import jeus.jms.wrapper.JMSTransactionHandler;
import jeus.jms.wrapper.TopicSessionWrapper;
import jeus.jms.wrapper.TopicSubscriberWrapper;
import jeus.util.ErrorMsgManager;
import jeus.util.message.JeusMessage_JMS;

public class XATopicSessionWrapper
extends JMSTransactionHandler
implements XATopicSession {
    private TopicSession Tses;
    private boolean isLocalTransaction;
    private String vendor;

    public XATopicSessionWrapper(Session Ses, boolean isLocalTransaction, String vendor) {
        super(Ses, isLocalTransaction);
        this.Tses = (TopicSession)Ses;
        this.isLocalTransaction = isLocalTransaction;
        this.vendor = vendor;
    }

    public TopicSession getTopicSession() throws JMSException {
        if (this.isLocalTransaction) {
            return new TopicSessionWrapper(this.Tses, true, this.vendor);
        }
        return new TopicSessionWrapper(((XATopicSession)this.Tses).getTopicSession(), false, this.vendor);
    }

    public Session getSession() throws JMSException {
        return this.getTopicSession();
    }

    public XAResource getXAResource() {
        return ((XATopicSession)this.Tses).getXAResource();
    }

    public boolean getTransacted() throws JMSException {
        return this.Tses.getTransacted();
    }

    public void commit() throws JMSException {
        throw new JMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4915));
    }

    public void rollback() throws JMSException {
        throw new JMSException(ErrorMsgManager.getLocalizedString((int)JeusMessage_JMS._4916));
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.Tses.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.Tses.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.Tses.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.Tses.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return this.Tses.createObjectMessage(object);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.Tses.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.Tses.createTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        return this.Tses.createTextMessage(text);
    }

    public void close() throws JMSException {
        this.Tses.close();
    }

    public void recover() throws JMSException {
        this.Tses.recover();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.Tses.getMessageListener();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.Tses.setMessageListener(listener);
    }

    public void run() {
        this.Tses.run();
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.Tses.getAcknowledgeMode();
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        return this.Tses.createProducer(destination);
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return new TopicSubscriberWrapper(this.Tses.createSubscriber((Topic)destination), this);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return new TopicSubscriberWrapper(this.Tses.createSubscriber((Topic)destination, messageSelector, false), this);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        return new TopicSubscriberWrapper(this.Tses.createSubscriber((Topic)destination, messageSelector, noLocal), this);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        throw new IllegalStateException("Queue operation not supported");
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        throw new IllegalStateException("Queue operation not supported");
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return new TopicSubscriberWrapper(this.Tses.createDurableSubscriber(topic, name), this);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return new TopicSubscriberWrapper(this.Tses.createDurableSubscriber(topic, name, messageSelector, noLocal), this);
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.Tses.createTemporaryTopic();
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        throw new IllegalStateException("Topic operation not supported");
    }

    public Queue createQueue(String queueName) throws JMSException {
        throw new IllegalStateException("Topic operation not supported");
    }

    public Topic createTopic(String topicName) throws JMSException {
        return this.Tses.createTopic(topicName);
    }

    public void unsubscribe(String name) throws JMSException {
        this.Tses.unsubscribe(name);
    }
}

