/*
 * Decompiled with CFR 0.152.
 */
package jeus.nio;

import java.security.AccessController;
import jeus.nio.ByteBuffer;
import sun.security.action.GetPropertyAction;

class Bits {
    private static int pageSize = -1;
    private static boolean unaligned;
    private static boolean unalignedKnown;
    private static volatile long reservedMemory;
    private static boolean memoryLimitSet;
    static final int JNI_COPY_TO_ARRAY_THRESHOLD = 6;
    static final int JNI_COPY_FROM_ARRAY_THRESHOLD = 6;

    private Bits() {
    }

    static short swap(short x) {
        return (short)(x << 8 | x >> 8 & 0xFF);
    }

    static char swap(char x) {
        return (char)(x << 8 | x >> 8 & 0xFF);
    }

    static int swap(int x) {
        return Bits.swap((short)x) << 16 | Bits.swap((short)(x >> 16)) & 0xFFFF;
    }

    static long swap(long x) {
        return (long)Bits.swap((int)x) << 32 | (long)Bits.swap((int)(x >> 32)) & 0xFFFFFFFFL;
    }

    private static char makeChar(byte b1, byte b0) {
        return (char)(b1 << 8 | b0 & 0xFF);
    }

    static char getCharL(ByteBuffer bb, int bi) {
        return Bits.makeChar(bb._get(bi + 1), bb._get(bi + 0));
    }

    static char getCharB(ByteBuffer bb, int bi) {
        return Bits.makeChar(bb._get(bi + 0), bb._get(bi + 1));
    }

    static char getChar(ByteBuffer bb, int bi, boolean bigEndian) {
        return bigEndian ? Bits.getCharB(bb, bi) : Bits.getCharL(bb, bi);
    }

    private static byte char1(char x) {
        return (byte)(x >> 8);
    }

    private static byte char0(char x) {
        return (byte)(x >> 0);
    }

    static void putCharL(ByteBuffer bb, int bi, char x) {
        bb._put(bi + 0, Bits.char0(x));
        bb._put(bi + 1, Bits.char1(x));
    }

    static void putCharB(ByteBuffer bb, int bi, char x) {
        bb._put(bi + 0, Bits.char1(x));
        bb._put(bi + 1, Bits.char0(x));
    }

    static void putChar(ByteBuffer bb, int bi, char x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putCharB(bb, bi, x);
        } else {
            Bits.putCharL(bb, bi, x);
        }
    }

    private static short makeShort(byte b1, byte b0) {
        return (short)(b1 << 8 | b0 & 0xFF);
    }

    static short getShortL(ByteBuffer bb, int bi) {
        return Bits.makeShort(bb._get(bi + 1), bb._get(bi + 0));
    }

    static short getShortB(ByteBuffer bb, int bi) {
        return Bits.makeShort(bb._get(bi + 0), bb._get(bi + 1));
    }

    static short getShort(ByteBuffer bb, int bi, boolean bigEndian) {
        return bigEndian ? Bits.getShortB(bb, bi) : Bits.getShortL(bb, bi);
    }

    private static byte short1(short x) {
        return (byte)(x >> 8);
    }

    private static byte short0(short x) {
        return (byte)(x >> 0);
    }

    static void putShortL(ByteBuffer bb, int bi, short x) {
        bb._put(bi + 0, Bits.short0(x));
        bb._put(bi + 1, Bits.short1(x));
    }

    static void putShortB(ByteBuffer bb, int bi, short x) {
        bb._put(bi + 0, Bits.short1(x));
        bb._put(bi + 1, Bits.short0(x));
    }

    static void putShort(ByteBuffer bb, int bi, short x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putShortB(bb, bi, x);
        } else {
            Bits.putShortL(bb, bi, x);
        }
    }

    private static int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return (b3 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | (b0 & 0xFF) << 0;
    }

    static int getIntL(ByteBuffer bb, int bi) {
        return Bits.makeInt(bb._get(bi + 3), bb._get(bi + 2), bb._get(bi + 1), bb._get(bi + 0));
    }

    static int getIntB(ByteBuffer bb, int bi) {
        return Bits.makeInt(bb._get(bi + 0), bb._get(bi + 1), bb._get(bi + 2), bb._get(bi + 3));
    }

    static int getInt(ByteBuffer bb, int bi, boolean bigEndian) {
        return bigEndian ? Bits.getIntB(bb, bi) : Bits.getIntL(bb, bi);
    }

    private static byte int3(int x) {
        return (byte)(x >> 24);
    }

    private static byte int2(int x) {
        return (byte)(x >> 16);
    }

    private static byte int1(int x) {
        return (byte)(x >> 8);
    }

    private static byte int0(int x) {
        return (byte)(x >> 0);
    }

    static void putIntL(ByteBuffer bb, int bi, int x) {
        bb._put(bi + 3, Bits.int3(x));
        bb._put(bi + 2, Bits.int2(x));
        bb._put(bi + 1, Bits.int1(x));
        bb._put(bi + 0, Bits.int0(x));
    }

    static void putIntB(ByteBuffer bb, int bi, int x) {
        bb._put(bi + 0, Bits.int3(x));
        bb._put(bi + 1, Bits.int2(x));
        bb._put(bi + 2, Bits.int1(x));
        bb._put(bi + 3, Bits.int0(x));
    }

    static void putInt(ByteBuffer bb, int bi, int x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putIntB(bb, bi, x);
        } else {
            Bits.putIntL(bb, bi, x);
        }
    }

    private static long makeLong(byte b7, byte b6, byte b5, byte b4, byte b3, byte b2, byte b1, byte b0) {
        return ((long)b7 & 0xFFL) << 56 | ((long)b6 & 0xFFL) << 48 | ((long)b5 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b3 & 0xFFL) << 24 | ((long)b2 & 0xFFL) << 16 | ((long)b1 & 0xFFL) << 8 | ((long)b0 & 0xFFL) << 0;
    }

    static long getLongL(ByteBuffer bb, int bi) {
        return Bits.makeLong(bb._get(bi + 7), bb._get(bi + 6), bb._get(bi + 5), bb._get(bi + 4), bb._get(bi + 3), bb._get(bi + 2), bb._get(bi + 1), bb._get(bi + 0));
    }

    static long getLongB(ByteBuffer bb, int bi) {
        return Bits.makeLong(bb._get(bi + 0), bb._get(bi + 1), bb._get(bi + 2), bb._get(bi + 3), bb._get(bi + 4), bb._get(bi + 5), bb._get(bi + 6), bb._get(bi + 7));
    }

    static long getLong(ByteBuffer bb, int bi, boolean bigEndian) {
        return bigEndian ? Bits.getLongB(bb, bi) : Bits.getLongL(bb, bi);
    }

    private static byte long7(long x) {
        return (byte)(x >> 56);
    }

    private static byte long6(long x) {
        return (byte)(x >> 48);
    }

    private static byte long5(long x) {
        return (byte)(x >> 40);
    }

    private static byte long4(long x) {
        return (byte)(x >> 32);
    }

    private static byte long3(long x) {
        return (byte)(x >> 24);
    }

    private static byte long2(long x) {
        return (byte)(x >> 16);
    }

    private static byte long1(long x) {
        return (byte)(x >> 8);
    }

    private static byte long0(long x) {
        return (byte)(x >> 0);
    }

    static void putLongL(ByteBuffer bb, int bi, long x) {
        bb._put(bi + 7, Bits.long7(x));
        bb._put(bi + 6, Bits.long6(x));
        bb._put(bi + 5, Bits.long5(x));
        bb._put(bi + 4, Bits.long4(x));
        bb._put(bi + 3, Bits.long3(x));
        bb._put(bi + 2, Bits.long2(x));
        bb._put(bi + 1, Bits.long1(x));
        bb._put(bi + 0, Bits.long0(x));
    }

    static void putLongB(ByteBuffer bb, int bi, long x) {
        bb._put(bi + 0, Bits.long7(x));
        bb._put(bi + 1, Bits.long6(x));
        bb._put(bi + 2, Bits.long5(x));
        bb._put(bi + 3, Bits.long4(x));
        bb._put(bi + 4, Bits.long3(x));
        bb._put(bi + 5, Bits.long2(x));
        bb._put(bi + 6, Bits.long1(x));
        bb._put(bi + 7, Bits.long0(x));
    }

    static void putLong(ByteBuffer bb, int bi, long x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putLongB(bb, bi, x);
        } else {
            Bits.putLongL(bb, bi, x);
        }
    }

    static float getFloatL(ByteBuffer bb, int bi) {
        return Float.intBitsToFloat(Bits.getIntL(bb, bi));
    }

    static float getFloatB(ByteBuffer bb, int bi) {
        return Float.intBitsToFloat(Bits.getIntB(bb, bi));
    }

    static float getFloat(ByteBuffer bb, int bi, boolean bigEndian) {
        return bigEndian ? Bits.getFloatB(bb, bi) : Bits.getFloatL(bb, bi);
    }

    static void putFloatL(ByteBuffer bb, int bi, float x) {
        Bits.putIntL(bb, bi, Float.floatToRawIntBits(x));
    }

    static void putFloatB(ByteBuffer bb, int bi, float x) {
        Bits.putIntB(bb, bi, Float.floatToRawIntBits(x));
    }

    static void putFloat(ByteBuffer bb, int bi, float x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putFloatB(bb, bi, x);
        } else {
            Bits.putFloatL(bb, bi, x);
        }
    }

    static double getDoubleL(ByteBuffer bb, int bi) {
        return Double.longBitsToDouble(Bits.getLongL(bb, bi));
    }

    static double getDoubleB(ByteBuffer bb, int bi) {
        return Double.longBitsToDouble(Bits.getLongB(bb, bi));
    }

    static double getDouble(ByteBuffer bb, int bi, boolean bigEndian) {
        return bigEndian ? Bits.getDoubleB(bb, bi) : Bits.getDoubleL(bb, bi);
    }

    static void putDoubleL(ByteBuffer bb, int bi, double x) {
        Bits.putLongL(bb, bi, Double.doubleToRawLongBits(x));
    }

    static void putDoubleB(ByteBuffer bb, int bi, double x) {
        Bits.putLongB(bb, bi, Double.doubleToRawLongBits(x));
    }

    static void putDouble(ByteBuffer bb, int bi, double x, boolean bigEndian) {
        if (bigEndian) {
            Bits.putDoubleB(bb, bi, x);
        } else {
            Bits.putDoubleL(bb, bi, x);
        }
    }

    static boolean unaligned() {
        if (unalignedKnown) {
            return unaligned;
        }
        GetPropertyAction pa = new GetPropertyAction("os.arch");
        String arch = AccessController.doPrivileged(pa);
        unaligned = arch.equals("i386");
        unalignedKnown = true;
        return unaligned;
    }

    static synchronized void unreserveMemory(long size) {
        if (reservedMemory > 0L) {
            reservedMemory -= size;
        }
    }

    static native void copyFromByteArray(Object var0, long var1, long var3, long var5);

    static native void copyToByteArray(long var0, Object var2, long var3, long var5);

    static void copyFromCharArray(Object src, long srcPos, long dstAddr, long length) {
        Bits.copyFromShortArray(src, srcPos, dstAddr, length);
    }

    static void copyToCharArray(long srcAddr, Object dst, long dstPos, long length) {
        Bits.copyToShortArray(srcAddr, dst, dstPos, length);
    }

    static native void copyFromShortArray(Object var0, long var1, long var3, long var5);

    static native void copyToShortArray(long var0, Object var2, long var3, long var5);

    static native void copyFromIntArray(Object var0, long var1, long var3, long var5);

    static native void copyToIntArray(long var0, Object var2, long var3, long var5);

    static native void copyFromLongArray(Object var0, long var1, long var3, long var5);

    static native void copyToLongArray(long var0, Object var2, long var3, long var5);

    static {
        unalignedKnown = false;
        reservedMemory = 0L;
        memoryLimitSet = false;
    }
}

